import {
  AfterViewInit,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { VerifyingModel } from '@models/user/VerifyingModel';
import {
  getConfigCarouselOWL,
  getConfigCarouselOWLTopSticky,
} from '@helpers/dataStatic.helper';
import { AdvertisingModel } from '@models/dashboard/AdvertisingModel';
import { OwlOptions } from 'ngx-owl-carousel-o';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { StyleStore } from '@stores/style.store';
import { cloneDeep } from 'lodash-es';
import { DomSanitizer } from '@angular/platform-browser';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { PagingHelper } from '@helpers/paging.helper';
import { ActivatedRoute, Router } from '@angular/router';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { OrderListModel } from '@models/orders/OrderListModel';
import { MessageStatic } from '@enums/messageStatic.enum';
import { ValueTypeStore } from '@stores/getValueType.store';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderDetailsComponent } from '../orders/orderList/components/orderDetails/orderDetails.component';
import { InboxSearch } from '@models/user/InboxSearch';
import { InboxListModel } from '@models/user/InboxListModel';
import { FileUploadService } from '@services/fileUpload.service';
import { InboxModel } from '@models/dashboard/InboxModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { CompanyInfoGet } from '@models/user/companyInfoModel';

@Component({
  selector: 'dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss'],
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class DashboardComponent implements OnInit, OnDestroy, AfterViewInit {
  dataCurrency: CurrencyModel[] = [];
  customOptions: OwlOptions = getConfigCarouselOWL();
  customOptionsTopSticky: OwlOptions;
  subscriptions = new Subscription();
  dashboardContent: any;
  dashboardContentHtml: any;
  dataVerifyModel: VerifyingModel[] = [];
  isLoadingGetAdvertising: boolean = false;
  dataAdvertisingAll: AdvertisingModel[] = [];
  dataAdvertisingTopStickyCompany: AdvertisingModel[] = [];
  dataAdvertisingTopCompany: AdvertisingModel[] = [];
  dataAdvertisingMiddleCompany: AdvertisingModel[] = [];
  dataAdvertisingBottomCompany: AdvertisingModel[] = [];
  dataAdvertisingTopStickyCompanyMobileCompany: AdvertisingModel[] = [];
  dataAdvertisingBottomStickyMobileCompany: AdvertisingModel[] = [];
  dataAdvertisingBottomStickyRightCompany: AdvertisingModel[] = [];
  dataAdvertisingBottomStickyLeftCompany: AdvertisingModel[] = [];
  dataAdvertisingBottomMiddleStickyMobileCompany: AdvertisingModel[] = [];
  dataAdvertisingTopMiddleStickyMobileCompany: AdvertisingModel[] = [];
  isLoading: boolean = true;
  search: OrderSearchModel = new OrderSearchModel();
  staticValueType = [];
  first: number = 0;
  ticket: any;
  last: number = 0;
  data: OrderListModel[] = [];
  isLoadingTableData: boolean = false;
  query: BaseParams;
  totalRecords: number = 0;
  rowsPerPage = this._pagingHelper.rowsPersPage();
  activeIndex: number = 0;
  message: string = MessageStatic.NotFoundOrder;
  isLoadingReciept: boolean;
  fileUrl: string;
  isLoadingTest: boolean = true;
  index: any;
  isLoadingImg: boolean = true;
  inboxSearch: InboxSearch = new InboxSearch();
  inboxList: InboxListModel[] = [];
  isLoadingFileUrls: boolean = false;
  dataInbox: InboxModel[] = [];
  companyInfo = new CompanyInfoGet();

  constructor(
    private _commonService: CommonService,
    private _styleStore: StyleStore,
    private _companyInfoStore: CompanyInfoStore,
    private sanitizer: DomSanitizer,
    public _pagingHelper: PagingHelper,
    private _router: Router,
    public dialogService: DialogService,
    public _valueTypeStore: ValueTypeStore,
    private cdr: ChangeDetectorRef,
    private _fileUploadService: FileUploadService,
    private _activatedroute: ActivatedRoute
  ) {}
  public ngAfterViewInit(): void {}

  ngOnInit(): void {
    this.customOptionsTopSticky = getConfigCarouselOWLTopSticky();
    this.getAllDashboard();
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
        this.cdr.detectChanges();
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
        this.cdr.detectChanges();
      }
    });

    this._styleStore.layoutWith.next({
      width: 'w-dashboard',
      isDashFooter: true,
    });
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getAllDashboard(): void {
    this.isLoadingGetAdvertising = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .get(Address.DashboardGetAll, {})
        .pipe(
          finalize(() => {
            this.isLoadingGetAdvertising = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res.data) {
            if (res.data.dasboardContent && res.data.dasboardContent.data) {
              this.dashboardContent = cloneDeep(res.data.dasboardContent.data);
              for (let item in this.dashboardContent) {
                this.dashboardContentHtml =
                  this.sanitizer.bypassSecurityTrustHtml(
                    this.dashboardContent[item]
                  );
              }
            }
            if (
              res.data.advertising != null &&
              res.data.advertising.data != null &&
              res.data.advertising.data.length > 0
            ) {
              this.dataAdvertisingAll = cloneDeep(res.data.advertising.data);

              this._fileUploadService.fileUrlGeneratorPutAdvertising(
                this.dataAdvertisingAll,
                'imageId'
              );

              this.dataAdvertisingTopStickyCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 318
                );

              this.dataAdvertisingTopCompany = this.dataAdvertisingAll.filter(
                (dataAd) => dataAd.position == 315
              );

              this.dataAdvertisingMiddleCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 319
                );

              this.dataAdvertisingBottomCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 313
                );

              this.dataAdvertisingTopStickyCompanyMobileCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 320
                );

              this.dataAdvertisingBottomStickyMobileCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 321
                );

              this.dataAdvertisingBottomStickyRightCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 312
                );

              this.dataAdvertisingBottomStickyLeftCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 317
                );

              this.dataAdvertisingTopMiddleStickyMobileCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 314
                );

              this.dataAdvertisingBottomMiddleStickyMobileCompany =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 316
                );
            }
            if (
              res.data.inbox != null &&
              res.data.inbox.data != null &&
              res.data.inbox.data.length > 0
            ) {
              for (let item of res.data.inbox.data) {
                if (item.importance == 153) {
                  this.dataInbox.push(item);
                }
              }
            }
          }
          this.isLoadingGetAdvertising = false;
          this.cdr.detectChanges();
          setTimeout(() => {
            window.dispatchEvent(new Event('resize'));
          }, 100);
          this.getOrderData();
        })
    );
  }

  getOrderData(event: any = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();
    this.query.pageSize = 3;
    if (this.search.status) this.search.status = Number(this.search.status);
    Object.assign(this.query, this.search);
    this.query = this._pagingHelper.requestParamsSet(event, this.query);
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderGetAll, this.query)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            if (res.data[0]) {
              this.data[0] = cloneDeep(res.data[0]);
            }
            if (res.data[1]) {
              this.data[1] = cloneDeep(res.data[1]);
            }
            if (res.data[2]) {
              this.data[2] = cloneDeep(res.data[2]);
            }
          }
          this.isLoading = false;
          this.cdr.detectChanges();
        })
    );
  }

  downloadReciept(item: any) {
    this.isLoadingReciept = true;
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + item.fileOrderId)
        .pipe(
          finalize(() => {
            this.isLoadingReciept = false;
          })
        )
        .subscribe(
          (response) => {
            this.fileUrl = response;
            window.open(this.fileUrl, '_blank');
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  transactionsNavigator(item: OrderListModel) {
    this._router.navigateByUrl(
      '/dashboard/orders/transactions/' + item.orderId
    );
  }

  toggle(item: any) {
    item.overlayVisible = !item.overlayVisible;
  }

  openOrdrDetail(item: any = null) {
    this._valueTypeStore.valueType.next(item.valueType);
    const ref = this.dialogService.open(OrderDetailsComponent, {
      data: {
        id: item ? item.orderId : null,
        orderType: item ? item.orderType : null,
        valueType: item ? item.valueType : null,
      },
      header:
        ' جزئیات سفارش ' +
        item.orderTypeName +
        ' با شماره: ' +
        item.orderNumber +
        '# ',
      height: '100%',
      styleClass: 'modal-order-details',
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }

  pay(item: any) {
    if (item.valueType) {
      switch (item.valueType) {
        case 'GFC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/giftcard/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );

          break;
        case 'IWP':
          this._router.navigateByUrl(
            '/dashboard/checkouts/internationalpayment/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );

          break;
        case 'PRM':
          this._router.navigateByUrl(
            '/dashboard/checkouts/premium-accounts/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
        case 'PAC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal-recharge/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;

        case 'PAB':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
        case 'PAS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal-sell/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;

        case 'SWF':
          this._router.navigateByUrl(
            '/dashboard/checkouts/swift/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;

        case 'APG':
          this._router.navigateByUrl(
            '/dashboard/checkouts/fee-multiple/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
        case 'PVS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/voucherperfectmoneysell/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;

        case 'PMS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingperfectmoney/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
        case 'PVC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/voucherperfectmoneybuy/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
        case 'PMC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/perfectmoneybuying/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;

        case 'WIC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/wiseaccountcharge/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
        case 'WIS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingwise/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
        case 'PYC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/payeeraccountrecharge/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
        case 'PYS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingpayeer/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;

        case 'TRI':
          this._router.navigateByUrl(
            '/dashboard/checkouts/remittancetoIran/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;

        case 'FRE':
          this._router.navigateByUrl(
            '/dashboard/checkouts/freeorder/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;

        case 'ICX':
          this._router.navigateByUrl(
            '/dashboard/checkouts/incomecash/' +
              item.orderId +
              '/' +
              this._activatedroute.snapshot.params['company']
          );
          break;
      }
    } else {
      if (item.status == 181 || item.status == 192) {
        switch (item.orderType) {
          case 161:
            this._router.navigateByUrl(
              '/dashboard/checkouts/swift/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;

          case 909:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;

          case 910:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-recharge/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;

          case 171:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-sell/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 162:
            this._router.navigateByUrl(
              '/dashboard/checkouts/fee/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 905:
            this._router.navigateByUrl(
              '/dashboard/checkouts/fee-multiple/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 175:
            this._router.navigateByUrl(
              '/dashboard/checkouts/university-tuition/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 177:
            this._router.navigateByUrl(
              '/dashboard/checkouts/dormitory-fee/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 163:
            this._router.navigateByUrl(
              '/dashboard/checkouts/perfectmoneybuying/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 178:
            this._router.navigateByUrl(
              '/dashboard/checkouts/buyvirtualserver/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 179:
            this._router.navigateByUrl(
              '/dashboard/checkouts/renewalvirtualserver/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 900:
            this._router.navigateByUrl(
              '/dashboard/checkouts/buytradeserver/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 901:
            this._router.navigateByUrl(
              '/dashboard/checkouts/renewaltradeserver/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 164:
            this._router.navigateByUrl(
              '/dashboard/checkouts/voucherperfectmoneybuy/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 166:
            this._router.navigateByUrl(
              '/dashboard/checkouts/voucherperfectmoneysell/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 165:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingperfectmoney/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 167:
            this._router.navigateByUrl(
              '/dashboard/checkouts/remittancetoIran/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 173:
            this._router.navigateByUrl(
              '/dashboard/checkouts/wiseaccountcharge/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 907:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingwise/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;

          case 169:
            this._router.navigateByUrl(
              '/dashboard/checkouts/payeeraccountrecharge/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 906:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingpayeer/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;

          case 999:
            this._router.navigateByUrl(
              '/dashboard/checkouts/freeorder/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
          case 959:
            this._router.navigateByUrl(
              '/dashboard/checkouts/incomecash/' +
                item.orderId +
                '/' +
                this._activatedroute.snapshot.params['company']
            );
            break;
        }
      }
    }
    if (item.status == 188) {
      this._router.navigateByUrl(
        '/dashboard/orders/depositDocument/' +
          item.orderType +
          '/' +
          item.orderId +
          '/' +
          this._activatedroute.snapshot.params['company']
      );
    }
  }

  navigateToOrders() {
    this._router.navigateByUrl('/dashboard/orders');
  }

  onImageLoad(evt) {
    if (evt && evt.target) {
      this.isLoadingImg = false;
    }
  }

  openWisePage() {
    this._router.navigateByUrl('/dashboard/services/wise/accountRecharge');
  }

  allServicesPage() {
    this._router.navigateByUrl('/dashboard/services');
  }
}
