import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';

import { Address } from '@enums/address.enum';

import { MessageStatic } from '@enums/messageStatic.enum';

import { CommonService } from '@services/common.service';
import { Location } from '@angular/common';

import { ConfirmationService, Message } from 'primeng/api';
import { DialogService } from 'primeng/dynamicdialog';
import { Subscription, finalize } from 'rxjs';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { BaseParams } from 'src/app/core/params/user/baseParams';

import { fadeAnimation } from 'src/app/core/animations/animations';

import { WalletModelGet } from '@models/user/WalletModelGet';

import { PagingHelper } from '@helpers/paging.helper';

import { response } from '@interfaces/response';
import { AlertHelper } from '@helpers/alert.helper';
import { NewDiscountComponent } from './newDiscount/newDiscount.component';
import { DiscountModelGet } from '@models/customerService/discountModelGet';
import { Icon } from '@enums/iconKey.enum';
import { Static } from '@interfaces/static';
import { AssignedUserDiscountModelGet } from '@models/customerService/assignedUSerDiscountGet';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { ColumnKey } from '@enums/columnKey.enum';
import { cloneDeep } from 'lodash-es';
 

@Component({
  selector: 'discount-table',
  templateUrl: './discounts.component.html',
  styleUrls: ['./discounts.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class DiscountsComponent implements OnInit, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    public dialogService: DialogService,
    private _router: Router,
    public _activatedroute: ActivatedRoute,
    public _pagingHelper: PagingHelper,
    public location: Location,
    private _activatedRoute: ActivatedRoute,
    private _messageService: AlertHelper,
    private confirmationService: ConfirmationService
  ) {}

  subscriptions = new Subscription();
  messages: Message[] = [];
  discountsAll: DiscountModelGet[] = [];

  filter: any = {};
  @Input() walletTransactions: WalletModelGet[] = [];
  @Input() totalRecords: number = 0;
  isLoading: boolean = false;
  query: BaseParams;
  overlayPanel: boolean;
  search: OrderSearchModel = new OrderSearchModel();
  dataUser: AssignedUserDiscountModelGet[] = [];
  walletId: string;
  walletAmount;
  message: string = MessageStatic.NotFound;
  rowsPerPage = this._pagingHelper.rowsPersPage();
  isLoadingActivate: boolean;
  loadingGetInfo: boolean;
  showAllDiscountTable: boolean;
  selectedStaticId: number;
  discountId: string;
  companyId: string;
  first: number = 0;
  last: number = 0;
  ticket: any;

  statusList: Static[] = [
    { id: 1, title: 'تمامی تخفیف ها' },
    { id: 2, title: 'تخفیف های تخصیص داده شده' },
  ];


  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
  }

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['company'])) {
      this.companyId = this._activatedRoute.snapshot.params['company'];
    }
    this.selectedStaticId = 1;
    this.query = new BaseParams();
    this.getData();
    this.cdr.detectChanges();
  }
  navigateTable(id: number) {
    if (id == 1) {
      this.selectedStaticId = 1;
      this.showAllDiscountTable = true;
    } else {
      this.selectedStaticId = 2;
      this.showAllDiscountTable = false;
    }
  }

  assignedUsersGet() {
    this.loadingGetInfo = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.CompayDiscountUserGet,
          { discountId: this.discountId },
          false
        )
        .pipe(
          finalize(() => {
            this.loadingGetInfo = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataUser = response.data;
            this.loadingGetInfo = false;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  goBackToPrevPage() {
    this.location.back();
  }


  getData(event: any = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();

    if (this.search.status) this.search.status = Number(this.search.status);
    Object.assign(this.query, this.search);
    this.query = this._pagingHelper.requestParamsSet(event, this.query);
    this.query.companyId = this.companyId;
    this.subscriptions.add(
      this._commonService
        .put(Address.CompanyDiscountGet, this.query)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            this.discountsAll = cloneDeep(res.data);
            this.totalRecords = res[ColumnKey.TotalRecordKey]
              ? res[ColumnKey.TotalRecordKey]
              : 0;
            this.first = this._pagingHelper.firstRecord(this.query);
            this.last = this._pagingHelper.lastRecord(
              this.query,
              this.totalRecords
            );

            this.cdr.detectChanges();
          }
        })
    );
  }

  navigateToCashExchange() {
    this._router.navigateByUrl('/dashboard/user/user-requests');
  }
  newDiscount(item: any = null, isEdit: boolean = null) {
    let headerText = '';
    if (isEdit) {
      headerText = 'ویرایش کد تخفیف';
    } else {
      headerText = 'کد تخفیف جدید';
    }
    const ref = this.dialogService.open(NewDiscountComponent, {
      header: headerText,
      height: ' ',
      width: '60%',
      styleClass: 'company-discount-code',
      dismissableMask: true,
      data: {
        discountAll: this.discountsAll,
        item: item,
        isEditDiscount: isEdit,
        companyId: this.companyId,
      },
    });
    ref.onClose.subscribe((model: any) => {
      if (model == true) {
        this.getData();
      }
    });
  }

  toggle(item: DiscountModelGet) {
    item.overlayDocuments = !item.overlayDocuments;
  }
  deleteCode(item: DiscountModelGet) {
    this.confirmationService.confirm({
      message: 'آیا از حذف کد اطمینان دارید؟',
      header: 'حذف کد تخفیف',
      icon: Icon.Warning,

      accept: () => {
        this.subscriptions.add(
          this._commonService
            .delete(Address.CompanyDiscountDelete, {
              discountId: item.discountId,
              companyId: this.companyId,
            })
            .pipe(
              finalize(() => {
                // this.isLoadingDelete = false;
                this.cdr.detectChanges();
              })
            )
            .subscribe(
              (res) => {
                this._messageService.success('کد تخفیف با موفقیت حذف شد.');
                this.getData();
                this.cdr.detectChanges();
              },
              (error: any) => {},
              () => {}
            )
        );
      },
      reject: () => {},
      key: 'confirmRemove1',
    });
  }
  assignCodeToUser(
    item: DiscountModelGet = null,
    fromGrid: boolean = null,
    fromButton: boolean = null
  ) {
    if (this.discountsAll.length > 0) {
      const ref = this.dialogService.open(NewDiscountComponent, {
        header: 'تخصیص به کاربر',
        height: ' ',
        width: '60%',
        styleClass: 'wallet-modal ',
        dismissableMask: true,
        data: {
          discountAll: this.discountsAll,
          fromGrid: fromGrid,
          singleDiscount: item,
          fromButton: fromButton,
          companyId: this.companyId,
        },
      });
      ref.onClose.subscribe((model: any) => {});
    }
  }
  deleteCodeAssignment(item: AssignedUserDiscountModelGet) {
    this.confirmationService.confirm({
      message: 'آیا از لغو تخصیص کد به کاربراطمینان دارید؟',
      header: 'حذف تخصیص کد تخفیف',
      icon: Icon.Warning,

      accept: () => {
        this.subscriptions.add(
          this._commonService
            .delete(Address.CompanyDiscountUserDelete, {
              UserId: item.userId,
              discountId: item.discountId,
            })
            .pipe(
              finalize(() => {
                this.cdr.detectChanges();
              })
            )
            .subscribe(
              (res) => {
                this._messageService.success(
                  'حذف تخصیص کد با موفقیت انجام شد.'
                );

                this.assignedUsersGet();
                this.cdr.detectChanges();
              },
              (error: any) => {},
              () => {}
            )
        );
      },
      reject: () => {},
      key: 'confirmRemove',
    });
  }
}
