import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
  Input,
  OnInit,
  ViewChild,
} from '@angular/core';

import { Address } from '@enums/address.enum';
import {
  convertDateToGeorgian,
  convertDateToJalali,
} from '@helpers/dateTime.helper';
import { response } from '@interfaces/response';
import { CommonService } from '@services/common.service';
import {
  DialogService,
  DynamicDialogConfig,
  DynamicDialogRef,
} from 'primeng/dynamicdialog';
import { getMaximumAmountOnlinePort } from '@helpers/dataStatic.helper';
import { Subscription, finalize } from 'rxjs';

import { PurchaseOrderModel } from 'src/app/core/params/order/PurchaseOrderModel';
import { OverlayPanel } from 'primeng/overlaypanel';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { cloneDeep } from 'lodash-es';
import { DiscountSave } from '@models/customerService/newDiscountCodeSaveModel';
import { StaticData } from '@models/static';
import { ICurrency } from '@interfaces/orders/iCurrency';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { Icon } from '@enums/iconKey.enum';
import { ConfirmationService } from 'primeng/api';
import { DiscountModelGet } from '@models/customerService/discountModelGet';
import { PagingHelper } from '@helpers/paging.helper';
import { AddUserModalComponent } from 'src/app/modules/user/add-user/addUserModal/addUserModal.component';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { ColumnKey } from '@enums/columnKey.enum';
import { SendAlaramDiscountCode } from '@models/customerService/sendAlarmDiscountCode';

@Component({
  selector: 'new-discount',
  templateUrl: 'newDiscount.component.html',
  styleUrls: ['./newDiscount.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class NewDiscountComponent implements OnInit {
  checkoutActivations: any;
  isLoading: boolean;
  isLoadingRedirect: boolean = false;
  rechargeValue: any;
  model: PurchaseOrderModel = new PurchaseOrderModel();
  maximumPrice: number = getMaximumAmountOnlinePort();
  suggestedValues = ['100000', '500000', '1000000', '10000000'];
  isLoadingSuggest: boolean = false;
  price: string = '20000';
  discountCode: string;
  orderTypeList: StaticData[] = [];
  isRandome: boolean = false;
  url: string;
  activeIndex: number;
  isLoadingGetUsers: boolean;
  selectedList: UserProfile[] = [];
  assignHeader = 'تخصیص کد تخفیف';
  loadingGetInfo: boolean;
  discountId: string;
  query: BaseParams;
  isLoadingSave: boolean;
  userId: string = null;
  selectedDiscountCod: string;
  selectDiscountOrderTypeName: string;
  isAssignedDiscountCode: boolean = false;
  search: OrderSearchModel = new OrderSearchModel();
  allowToSubmit: boolean;
  discountLength: any = 200;
  @Input() totalRecords: number = 0;
  sendAlarmDiscountModel: SendAlaramDiscountCode = new SendAlaramDiscountCode();
  isSendAlaramDiscount: boolean;
  orderOptions = [
    { value: 'newCode', title: 'ایجاد کد تخفیف' },
    { value: 'users', title: 'تخصیص به کاربران' },
  ];
  discountType = [
    { value: 656, title: 'درصدی' },
    { value: 657, title: 'تومانی' },
  ];
  codeApplyWay = [
    { value: false, title: 'اتوماتیک' },
    { value: true, title: 'دستی' },
  ];
  discountValueApplyWay = [
    { value: 20031, title: 'تومانی' },
    { value: 20032, title: 'ارزی' },
  ];
  @ViewChild('account') input: ElementRef;
  randomChar = this.randomString(10, '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ');
  currencyList: [{ currencyId: '' }] = null;
  currencyOrderList: ICurrency[] = [];
  rowsPerPage = this._pagingHelper.rowsPersPage();
  companyInfo = new CompanyInfoGet();
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    public _pagingHelper: PagingHelper,
    public config: DynamicDialogConfig,
    public ref: DynamicDialogRef,
    private _alert: AlertHelper,
    private confirmationService: ConfirmationService,
    private _messageService: AlertHelper,
    private _companyInfoStore: CompanyInfoStore,
    public dialogService: DialogService
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  isLoadingGetOrderType: boolean;
  isLoadingGetCurrencyType: boolean;
  discountSaveModel = new DiscountSave();
  singleDiscount = new DiscountModelGet();
  discountsAll: DiscountModelGet[] = [];
  first: number = 0;
  last: number = 0;
  searchResult: UserProfile[] = [];
  dataUser: UserProfile[] = [];
  dataUserAssigned: UserProfile[] = [];
  inputSearch: any;
  timeout: any = null;
  op;
  isDesktop: boolean;
  isLoadingGetAllDiscount: boolean;
  isShow: boolean = true;
  chooseFromSuggestions(n: string) {
    this.price = n;
  }
  randomString(length: number, chars: string) {
    let result = '';
    for (let i = length; i > 0; --i)
      result += chars[Math.floor(Math.random() * chars.length)];
    return result;
  }
  discountCodeConditions() {
    if (this.discountSaveModel.codeType == false) {
      this.discountSaveModel.code = this.randomChar;
    } else {
      this.discountSaveModel.code = '';
    }
  }
  subscriptions = new Subscription();
  countSearchInput(op: OverlayPanel) {
    this.getResult(op, event);
  }

  getUserAll(): void {
    this.isLoadingGetUsers = true;
    this.cdr.detectChanges();

    this.subscriptions.add(
      this._commonService
        .put(Address.ComopanyClientGetAll, {
          companyId: this.discountSaveModel.companyId,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetUsers = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataUser = res.data;

            this.isLoadingGetUsers = false;
          }
          this.cdr.detectChanges();
        })
    );
  }

  getResult(op: OverlayPanel, e: any) {
    this.searchResult = this.dataUser.filter(
      (q) =>
        (!stringIsEmptyOrNull(q.family) &&
          q.family.includes(this.inputSearch)) ||
        (!stringIsEmptyOrNull(q.name) && q.name.includes(this.inputSearch)) ||
        (!stringIsEmptyOrNull(q.nationalCode) &&
          q.nationalCode.includes(this.inputSearch)) ||
        (!stringIsEmptyOrNull(q.mobile) && q.mobile.includes(this.inputSearch))
    );

    if (
      !stringIsEmptyOrNull(this.inputSearch) &&
      this.searchResult.length > 0 &&
      op &&
      e
    ) {
      op.show(e);
    }
  }

  appendToUserList(indx: number) {
    this.searchResult[indx].isTemporal = true;

    this.dataUserAssigned.push(this.searchResult[indx]);
    this.dataUserAssigned = this.dataUserAssigned.filter(
      (item, index) => this.dataUserAssigned.indexOf(item) === index
    );
    this.allowToSubmit = true;
    this.selectedList.push(this.searchResult[indx]);
    this.selectedList = this.selectedList.filter(
      (item, index) => this.selectedList.indexOf(item) === index
    );
  }

  deleteFromTemporalList(item: any) {
    this.dataUserAssigned.splice(this.dataUserAssigned.indexOf(item), 1);
    this.selectedList.splice(this.selectedList.indexOf(item), 1);

    if (this.selectedList.length == 0) {
      this.allowToSubmit = false;
    }
  }

  getOrderType() {
    this.isLoadingGetOrderType = true;

    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.StaticGet, { parentId: 160 })
        .pipe(
          finalize(() => {
            this.isLoadingGetOrderType = false;
          })
        )
        .subscribe((res) => {
          if (res.data) {
            this.orderTypeList = cloneDeep(res.data);

            this.isLoadingGetOrderType = false;
          }

          this.cdr.detectChanges();
        })
    );
  }

  currencyConditions() {
    if (
      this.discountSaveModel.isGroup == 'multiple' &&
      this.currencyList &&
      this.currencyList.length > 0
    ) {
      if (this.discountSaveModel.isAllCurrencies) {
        this.discountSaveModel.isAllCurrencies = false;
        this.discountSaveModel.isGroup = true;
      }
      let tempList = [];

      for (let currency of this.currencyList) {
        tempList.push(currency.currencyId);
      }
      this.discountSaveModel.currencyIdList = tempList.toString();

      this.discountSaveModel.currencyId = null;
    }
    if (
      this.discountSaveModel.isGroup == 'one' &&
      this.discountSaveModel.currencyId
    ) {
      this.discountSaveModel.currencyIdList = null;
      this.discountSaveModel.isGroup = false;
      this.discountSaveModel.isAllCurrencies = false;
    }
    if (this.discountSaveModel.isGroup == 'all') {
      this.discountSaveModel.isGroup = false;
      this.discountSaveModel.isAllCurrencies = true;
      this.discountSaveModel.currencyIdList = null;
      this.discountSaveModel.currencyId = null;
    }
  }
  getCurrencyType(): void {
    this.isLoadingGetCurrencyType = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.CurrencyGetAll, {
          orderType: this.discountSaveModel.orderType,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetCurrencyType = false;
          })
        )
        .subscribe((res) => {
          if (res.data) {
            this.currencyOrderList = cloneDeep(res.data);
            this.discountSaveModel.currencyId =
              this.currencyOrderList[0].currencyId;
            this.isLoadingGetCurrencyType = false;
          }

          this.cdr.detectChanges();
        })
    );
  }

  ngOnInit() {
    if (this.companyInfo.discountAmountType == 656) {
      this.discountLength = 3;
    }

    if (this.config.data && this.config.data.companyId) {
      this.discountSaveModel.companyId = this.config.data.companyId;
      this.singleDiscount = this.config.data.singleDiscount;
    }

    if (this.config.data && this.config.data.fromGrid) {
      this.activeIndex = 1;
      this.singleDiscount = this.config.data.singleDiscount;
      this.discountSaveModel.discountId = this.singleDiscount.discountId;

      this.selectDiscountOrderTypeName = this.singleDiscount.orderTypeName;
      this.selectedDiscountCod = this.singleDiscount.discountCode;
      if (!stringIsEmptyOrNull(this.discountSaveModel.discountId)) {
        this.assignedUsersGet();
      }
    } else {
      this.activeIndex = 0;
    }

    if (this.config.data && this.config.data.fromButton) {
      this.activeIndex = 1;
      this.discountsAll = this.config.data.discountAll;
    }
    if (this.config.data && this.config.data.discountAll) {
      this.discountsAll = this.config.data.discountAll;
    }

    if (this.config.data && this.config.data.isEditDiscount) {
      this.discountSaveModel.discount = this.config.data.item.discount;
      this.discountSaveModel.discountId = this.config.data.item.discountId;
      this.discountSaveModel.code = this.config.data.item.discountCode;
      this.discountSaveModel.isActive = this.config.data.item.isActive;

      this.discountSaveModel.expireDateFa = convertDateToJalali(
        this.config.data.item.expireDate
      );
    } else {
      this.discountSaveModel.codeType = false;

      this.discountCodeConditions();
    }
    this.getUserAll();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  editDiscountAPI() {
    this.subscriptions.add(
      this._commonService
        .put(Address.CompanyDiscountUpdate, this.discountSaveModel)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('کد تخفیف با موفقیت ویرایش شد');

            this.discountSaveModel.discountId = response.data.id;

            this.ref.close(true);
          },
          (error) => { }
        )
    );
  }

  saveDiscountAPI() {
    this.subscriptions.add(
      this._commonService
        .post(Address.CompanyDiscountSave, this.discountSaveModel)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.discountSaveModel.discountId = response.data.id;
            this._alert.success('کد تخفیف با موفقیت ثبت شد');
            this.getDataAllDiscount();
            this.activeIndex = 1;
          },
          (error) => { }
        )
    );
  }
  submitDiscount() {
    this.discountSaveModel.expireDate = convertDateToGeorgian(
      this.discountSaveModel.expireDateFa
    );
    if (this.discountSaveModel.discount >= 0 && this.discountSaveModel.code) {
      this.discountSaveModel.title = this.discountSaveModel.code;
      this.discountSaveModel.currencyId = null;
      this.discountSaveModel.orderType = null;
      this.isLoading = true;
      this.cdr.detectChanges();
      if (this.config.data.isEditDiscount) {
        this.editDiscountAPI();
      } else {
        this.saveDiscountAPI();
      }
    } else {
      this._alert.error('لطفا از تکمیل تمامی ورودی ها مطمئن شوید.');
    }
  }
  submitToAssignmentApi() {
    this.subscriptions.add(
      this._commonService
        .post(Address.CompanyDiscountUserSave, {
          userId: this.userId,
          discountId: this.discountSaveModel.discountId,
          companyId: this.discountSaveModel.companyId,
          sendToAll: this.discountSaveModel.sendToAll,
        })
        .pipe(
          finalize(() => {
            this.isLoadingSave = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (res) => {
            this._alert.success('کد تخفیف با موفقیت تخصیص داده شد');
            this.isLoadingSave = false;

            this.ref.close(true);
            this.cdr.detectChanges();
          },
          (error: any) => { },
          () => { }
        )
    );
  }
  submit() {
    this.confirmationService.confirm({
      message: 'آیا از تخصیص کد تخفیف به کاربران طمینان دارید؟',
      header: this.assignHeader,
      icon: Icon.Warning,

      accept: () => {
        if (this.selectedList.length == 1) {
          this.userId = this.selectedList[0].userId;
          this.submitToAssignmentApi();
        }

        if (this.selectedList.length > 1) {
          this._alert.info(
            'در حال حاضر امکان تخصیص بصورت گروهی وجود ندارد. لطفا فقط یک کاربر را انتخاب کنید.'
          );
        }

        if (this.discountSaveModel.sendToAll) {
          this.userId = null;
          this.submitToAssignmentApi();
        }
      },
      reject: () => { },
      key: 'confirmRemove1',
    });
  }

  getDataAllDiscount(): void {
    this.isLoadingGetAllDiscount = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();
    Object.assign(this.query, this.search);

    this.subscriptions.add(
      this._commonService
        .put(Address.CompanyDiscountGet, {
          companyId: this.discountSaveModel.companyId,
        })
        .pipe(
          finalize(() => {
            this.isLoading = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            this.discountsAll = res.data;

            let singleDiscount: DiscountModelGet[] = [];
            singleDiscount = this.discountsAll.filter(
              (q) => q.discountId == this.discountSaveModel.discountId
            );
            this.singleDiscount = singleDiscount[0];

            this.isLoadingGetAllDiscount = false;

            this.cdr.detectChanges();
          }
        })
    );
  }

  deleteCodeAssignment(item: any) {
    this.confirmationService.confirm({
      message: 'آیا از لغو تخصیص کد به کاربراطمینان دارید؟',
      header: 'لغو تخصیص کد تخفیف',
      icon: Icon.Warning,

      accept: () => {
        this.subscriptions.add(
          this._commonService
            .delete(Address.CompanyDiscountUserDelete, {
              UserId: item.userId,
              discountId: item.discountId,
              companyId: this.discountSaveModel.companyId,
            })
            .pipe(
              finalize(() => {
                this.cdr.detectChanges();
              })
            )
            .subscribe(
              (res) => {
                this._alert.success(' لغو تخصیص کد با موفقیت انجام شد.');
                this.assignedUsersGet();
                this.cdr.detectChanges();
              },
              (error: any) => { },
              () => { }
            )
        );
      },
      reject: () => { },
      key: 'confirmRemove1',
    });
  }

  assignedUsersGet(event: any = null) {
    this.loadingGetInfo = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();

    if (this.search.status) this.search.status = Number(this.search.status);
    Object.assign(this.query, this.search);
    this.query.companyId = this.discountSaveModel.companyId;
    this.query.discountId = this.discountSaveModel.discountId;
    this.query.pageSize = 5;
    this.query = this._pagingHelper.requestParamsSet(event, this.query);

    this.subscriptions.add(
      this._commonService
        .put(Address.CompayDiscountUserGet, this.query)
        .pipe(
          finalize(() => {
            this.loadingGetInfo = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            this.dataUserAssigned = cloneDeep(res.data);
            this.totalRecords = res[ColumnKey.TotalRecordKey]
              ? res[ColumnKey.TotalRecordKey]
              : 0;
            this.first = this._pagingHelper.firstRecord(this.query);
            this.last = this._pagingHelper.lastRecord(
              this.query,
              this.totalRecords
            );
            this.loadingGetInfo = false;
          }
          this.cdr.detectChanges();
        })
    );
  }

  calculateDiscountTotal(id: string) {
    let total = 0;

    if (this.discountsAll) {
      for (let discount of this.discountsAll) {
        if (discount.discountId === id) {
          total++;
        }
      }
    }

    return total;
  }
  userModalSaveAndEdit(
    item: UserProfile = null,
    isEdit: boolean = null,
    isOld: boolean = null,
    isSubmited: boolean = false
  ) {
    let textHeader = '';
    if (isEdit) {
      textHeader = 'ویرایش اطلاعات کاربری';
    } else {
      textHeader = 'افزودن کاربر جدید';
    }

    const ref = this.dialogService.open(AddUserModalComponent, {
      header: textHeader,
      height: 'auto',
      width: '40%',
      styleClass: 'wallet-modal ',
      dismissableMask: true,
      data: {
        user: item,
        isEdit: isEdit,
        isOld: isOld,
        isSubmited: isSubmited,
        companyId: this.discountSaveModel.companyId,
      },
    });
    ref.onClose.subscribe((model: any) => {
      if (model == true) {
        this.getUserAll();
      }
    });
  }

  sendAlarmDiscountCode(item: any) {
    if (stringIsEmptyOrNull(item.discountId)) {
      this._alert.warning('ابتدا کد تخفیف را به کاربر تخصیص دهید و سپس پیامک را ارسال کنید.')
    } else {
      this.sendAlarmDiscountModel.companyId = this.companyInfo.companyId;
      this.sendAlarmDiscountModel.discountId = item.discountId;
      this.sendAlarmDiscountModel.userId = item.userId;

      this.confirmationService.confirm({
        message: 'آیا از ارسال کد تخفیف به کاربر مطمئن هستید؟',
        header: 'ارسال پیامک کد تخفیف',
        icon: Icon.Warning,

        accept: () => {
          this.isSendAlaramDiscount = true;
          this.cdr.detectChanges();
          this.subscriptions.add(
            this._commonService
              .put(
                Address.CompanySendAlarmDiscountCode,
                this.sendAlarmDiscountModel
              )
              .pipe(
                finalize(() => {
                  this.isSendAlaramDiscount = false;
                  this.cdr.detectChanges();
                })
              )
              .subscribe((res) => {
                if (res) {
                  this._messageService.success(
                    'پیامک کد تخفیف با موفقیت ارسال شد.'
                  );
                }
                this.isSendAlaramDiscount = false;
                this.cdr.detectChanges();
              })
          );
        },
        reject: () => { },
        key: 'confirmRemove1',
      });
    }

  }
}
