import { VerifyingModel } from '@models/user/VerifyingModel';
import { Component, OnDestroy, OnInit, OnChanges } from '@angular/core';
import { Address } from '@enums/address.enum';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { UserStore } from '@stores/user.store';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { DocumentsModel } from '@models/user/DocumentsModel';
import { ActivatedRoute, Router, NavigationStart } from '@angular/router';
import { IBankAccount } from '@interfaces/user/IBankAccount';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { StyleStore } from '@stores/style.store';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { WalletModelGet } from '@models/user/WalletModelGet';
import { cloneDeep } from 'lodash-es';
@Component({
  selector: 'app-user',
  templateUrl: './financial.component.html',
  styleUrls: ['./financial.component.scss'],
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class FinancialComponent implements OnInit, OnDestroy, OnChanges {
  activeIndex: number = 0;
  indexTab: number = 0;
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetDocument: boolean = false;
  isLoadingGetBankAccount: boolean = false;

  dataVerifying: VerifyingModel[] = [];
  data: UserProfile;
  documents: DocumentsModel[] = null;
  bankAccount: IBankAccount[] = [];
  nationalCardId: string = null;
  selfiImageId: string = null;
  isCompeleteBaseInformation: boolean = false;
  isCompeleteTel: boolean = false;
  isCompeleteEmail: boolean = false;
  isCompleteMobile: boolean = false;
  isCompeleteBanking: boolean = false;
  isCompeleteDocumentSelfi: boolean = false;
  isCompeleteDocumentNationalCard: boolean = false;
  query: BaseParams;
  walletTransactions: WalletModelGet[] = [];
  totalRecords: number = 0;
  isLoadingGetWallet: boolean;
  constructor(
    private _commonService: CommonService,
    private _userStore: UserStore,
    private _activatedRoute: ActivatedRoute,
    private _router: Router,
    private _styleStore: StyleStore
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[3] != undefined &&
          event.url.split('/')[3] != null &&
          event.url.split('/')[3] != ''
        ) {
          this.handleChangeRoute(event.url.split('/')[3]);
        }
      }
    });
  }

  ngOnChanges() {}
  ngOnInit(): void {
    this._styleStore.layoutWith.next({
      width: 'w-full',
      isDashFooter: false,
    });
    if (this._activatedRoute.snapshot.params['active']) {
      this.handleChangeRoute(this._activatedRoute.snapshot.params['active']);
    }

    this.isLoadingGet = true;
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
      this.isLoadingGet = false;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.isLoadingGet = false;
        this.data = res;
      }
    });
    this.userGetVerifying();
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getBankAccount() {
    this.isLoadingGetBankAccount = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.BankAccountGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetBankAccount = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.bankAccount = response.data;
          },
          (error) => {}
        )
    );
  }
  getDataWallet() {
    this.isLoadingGetWallet = true;

    this.query = new BaseParams();
    this.query.pageSize = 100;
    this.subscriptions.add(
      this._commonService
        .put(Address.TransActionGetAll, { transactionTypeList: '683,684' })
        .pipe(
          finalize(() => {
            this.isLoadingGetWallet = false;
          })
        )
        .subscribe((res) => {
          if (res) {
            this.walletTransactions = cloneDeep(res.data);
            this.totalRecords = this.walletTransactions.length;
          }
        })
    );
  }

  userGetInfo() {
    this.isLoadingGet = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.data = response.data;
          },
          (error) => {}
        )
    );
  }

  userGetDocument() {
    this.isLoadingGetDocument = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.DocumentGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetDocument = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.documents = response.data;
            if (this.documents != null) {
              for (let item of this.documents) {
                switch (item.documentType) {
                  case 136:
                    this.nationalCardId = item.fileId;
                    break;
                  case 139:
                    this.selfiImageId = item.fileId;
                    break;
                  default:
                    break;
                }
              }
            }
          },
          (error) => {}
        )
    );
  }

  handleChange(e) {
    e.originalEvent.target.scrollIntoView({
      behavior: 'smooth',
      block: 'center',
      inline: 'center',
    });
    switch (e.index) {
      case 0:
        this._router.navigateByUrl(
          '/dashboard/user/baseInformation/' +
            this._activatedRoute.snapshot.params['company']
        );
        break;
      case 1:
        this._router.navigateByUrl(
          '/dashboard/user/bankAccount/' +
            this._activatedRoute.snapshot.params['company']
        );
        if (!this.bankAccount || this.bankAccount.length == 0)
          this.getBankAccount();
        break;
      case 2:
        this._router.navigateByUrl(
          '/dashboard/user/document/' +
            this._activatedRoute.snapshot.params['company']
        );
        if (!this.documents) this.userGetDocument();
        break;

      case 3:
        this._router.navigateByUrl(
          '/dashboard/user/wallet/' +
            this._activatedRoute.snapshot.params['company']
        );
        if (
          this.walletTransactions.length == 0 ||
          this.walletTransactions === null
        )
          this.getDataWallet();

        break;
      case 4:
        this._router.navigateByUrl(
          '/dashboard/user/security/' +
            this._activatedRoute.snapshot.params['company']
        );
        break;
    }
  }

  handleChangeRoute(e: string) {
    switch (e) {
      case 'baseInformation':
        this.indexTab = 0;
        break;
      case 'bankAccount':
        this.indexTab = 1;
        if (!this.bankAccount || this.bankAccount.length == 0)
          this.getBankAccount();
        break;
      case 'document':
        this.indexTab = 2;
        if (!this.documents) this.userGetDocument();
        break;
      case 'wallet':
        this.indexTab = 3;
        if (
          this.walletTransactions.length == 0 ||
          this.walletTransactions === null
        )
          this.getDataWallet();

        break;
      case 'security':
        this.indexTab = 4;
        break;
    }
  }

  userGetVerifying() {
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            this.dataVerifying = response.data;
            for (let item of this.dataVerifying) {
              switch (item.typeVerifying) {
                case 118:
                  if (item.isAccept == true)
                    this.isCompeleteBaseInformation = true;
                  break;
                case 111:
                  if (item.isAccept == true) this.isCompleteMobile = true;
                  break;
                case 112:
                  if (item.isAccept == true) this.isCompeleteEmail = true;
                  break;
                case 113:
                  if (item.isAccept == true) this.isCompeleteTel = true;
                  break;
                case 114:
                  if (item.isAccept == true)
                    this.isCompeleteDocumentNationalCard = true;
                  break;
                case 116:
                  if (item.isAccept == true)
                    this.isCompeleteDocumentSelfi = true;
                  break;
                case 115:
                  if (item.isAccept == true) this.isCompeleteBanking = true;
                  break;
              }
            }
          },
          (error) => {}
        )
    );
  }
  getInfoActionUser(e) {
    if (e != undefined && e == true) {
      this.isCompeleteBaseInformation = true;
    }
  }
  getInfoActionBank(e) {
    if (e != undefined && e == true) {
      this.isCompeleteBanking = true;
    }
  }
  getInfoActionTel(e) {
    if (e != undefined && e == true) {
      this.isCompeleteTel = true;
    }
  }
  getInfoActionEmail(e) {
    if (e != undefined && e == true) {
      this.isCompeleteEmail = true;
    }
  }

  getInfoActionMobile(e) {
    if (e != undefined && e == true) {
      this.isCompleteMobile = true;
    }
  }
}
