import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
 
import { FinancialComponent } from './financial.component';
import { DiscountsComponent } from './discounts/discounts.component';
import { NewDiscountComponent } from './discounts/newDiscount/newDiscount.component';
import { PersianCalenderComponent } from '@components/persianCalender/persianCalender.component';

const routes: Routes = [
  {
    path: '',
    
    component: FinancialComponent,
    data:{breadcrumb: 'کد تخفیف' },
  },
  {
    path: 'discount-codes/:company',
    component: DiscountsComponent,
    data:{breadcrumb: 'لیست کد های تخفیف' },
  },
  {
    path: 'new-discount-code/:company',
    component: NewDiscountComponent,
    data:{breadcrumb: 'ایجاد کد تخفیف' },
  },
 
 
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class FinancialRoutingModule { }
