import { ChangeDetectorRef, Component, OnInit } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { cloneDeep } from 'lodash-es';
import { DeviceDetectorService } from 'ngx-device-detector';
import { Subscription, finalize } from 'rxjs';

@Component({
  selector: 'footer-site',
  templateUrl: 'footer.component.html',
  styleUrls: ['footer.component.scss'],
})
export class FooterComponent implements OnInit {
  visibleRoles: boolean = false;
  isLoadingGet: boolean = true;
  subscriptions = new Subscription();

  isDesktop: boolean;
  termsConditions: any;
  termsConditionsHtml: any;
  constructor(
    private cdr: ChangeDetectorRef,
    private _commonService: CommonService,
    public _deviceDetectorService: DeviceDetectorService,
    private sanitizer: DomSanitizer
  ) {}

  ngOnInit() {
    this.getTermsConditionsContent();
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.cdr.detectChanges();
  }

  getTermsConditionsContent(): void {
    this.subscriptions.add(
      this._commonService
        .put(Address.TermsConditionsGet, {})
        .pipe(finalize(() => {}))
        .subscribe((res) => {
          if (res && res.data) {
            this.termsConditions = cloneDeep(res.data);
            for (let item in this.termsConditions) {
              this.termsConditionsHtml = this.sanitizer.bypassSecurityTrustHtml(
                this.termsConditions[item]
              );
            }
          }
        })
    );
  }
}
