import {
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnInit,
  Output,
} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { UserStore } from '@stores/user.store';
import { CommonService } from '@services/common.service';
import { UserProfile } from '@interfaces/user/userProfile';
import { finalize, Subscription } from 'rxjs';
import { ConfirmationService } from 'primeng/api';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { LogingoutStore } from '@stores/isLogingout.store';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';

@Component({
  selector: 'header',
  templateUrl: 'header.component.html',
  styleUrls: ['../layout.component.scss'],
})
export class HeaderComponent implements OnInit {
  subscriptions = new Subscription();
  imageDefault: string = 'assets/images/avatar.png';
  status: boolean = false;
  @Input() data: UserProfile = new UserProfile();
  @Input() inboxTotalRecords: any;
  @Input() ticketsTotalRecords: any;
  @Output() blurFlag: EventEmitter<boolean> = new EventEmitter<boolean>();
  isLoadingLogout: boolean = false;
  companyId: string;
  constructor(
    private _userStore: UserStore,
    private _router: Router,
    private _commonService: CommonService,
    private confirmationService: ConfirmationService,
    private cdr: ChangeDetectorRef,
    private _logoutStore: LogingoutStore,
    private _activatedRoute: ActivatedRoute
  ) {
    this._userStore.user.subscribe((res) => {
      this.data = res;
    });
  }

  openTickets() {
    this._router.navigateByUrl('/dashboard/tickets/' + this.companyId);
  }
  openUserAccont() {
    this._router.navigateByUrl(
      '/dashboard/user/baseInformation/' + this.companyId
    );
  }
  openOrder() {
    this._router.navigateByUrl('/dashboard/orders/invoices/' + this.companyId);
  }
  openInbox() {
    this._router.navigateByUrl('/dashboard/inbox/all/' + this.companyId);
  }

  ngOnInit() {
    if (
      !stringIsEmptyOrNull(
        this._activatedRoute.snapshot['_routerState'].url.split('/')[
          this._activatedRoute.snapshot['_routerState'].url.split('/').length -
            1
        ]
      )
    ) {
      this.companyId =
        this._activatedRoute.snapshot['_routerState'].url.split('/')[
          this._activatedRoute.snapshot['_routerState'].url.split('/').length -
            1
        ];
    }
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.data = res;
      }
    });
  }

  confirmLogout() {
    this.confirmationService.confirm({
      message: 'آیا از خروج از برنامه اطمینان دارید؟',
      key: 'exit',
      accept: () => {
        this.isLoadingLogout = true;
        this._logoutStore.isLogout.next(this.isLoadingLogout);
        this._logoutStore.isLogoutBehavior.next(this.isLoadingLogout);
        this.logout();
      },
    });
  }

  openWalletPage() {
    this._router.navigateByUrl('/dashboard/user/wallet/' + this.companyId);
  }

  logout() {
    this.subscriptions.add(
      this._commonService
        .put(Address.SignOut, {}, false)
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            localStorage.clear();
            //  this.authService.signOut();
            this._router.navigateByUrl('/loginByUserName');
            this.isLoadingLogout = false;
            this.cdr.detectChanges();
            this._logoutStore.isLogout.next(this.isLoadingLogout);
            this._logoutStore.isLogoutBehavior.next(this.isLoadingLogout);
          },
          (error) => {}
        )
    );
  }

  show() {
    this.blurFlag.emit(true);
  }

  hide() {
    this.blurFlag.emit(false);
  }
}
