import { TranslateHelper } from '@helpers/translate.helper';
import { ChangeDetectionStrategy, ChangeDetectorRef, Component, EventEmitter, Input, OnChanges, OnDestroy, OnInit, Output } from "@angular/core";
import { ActivatedRoute, Router } from "@angular/router";
import { Address } from "@enums/address.enum";
import { stringIsEmptyOrNull } from "@helpers/validator.helper";
import { CommonService } from "@services/common.service";
import { LanguagesService } from "@services/languages.service";
import { Subscription, finalize } from "rxjs";
import { response } from '@interfaces/response';
import { TranslateService } from "@ngx-translate/core";

@Component({
    selector: 'language',
    templateUrl: 'language.component.html',
    styleUrls: ['language.component.scss'],
    changeDetection: ChangeDetectionStrategy.OnPush,

})


export class LanguageComponent implements OnInit, OnDestroy, OnChanges {

    subscriptions = new Subscription();
    @Input() selectedKey: string;
    selectedLanguage: any;
    @Output() languageKeyChange = new EventEmitter();
    constructor(
        private _activatedroute: ActivatedRoute,
        private _languages: LanguagesService,
        private _router: Router,
        private _commonService: CommonService,
        private _translateService: TranslateService,
        private _translateHelper: TranslateHelper,
        private cdr: ChangeDetectorRef
    ) {


    }
    dataLanguage: any[] = this._languages.languages;
    ngOnInit(): void {
        if (!stringIsEmptyOrNull(this.selectedKey)) {
            this.selectedLanguage = this.dataLanguage.filter(a => a.key == this.selectedKey)[0];
        }

        else if (stringIsEmptyOrNull(this._activatedroute.snapshot.params['language'])) {
            this.selectedLanguage = this.dataLanguage.filter(a => a.key == 'fa')[0];
        }

        this.cdr.detectChanges();
    }
    ngOnDestroy() {
        this.subscriptions.unsubscribe();
    }
    ngOnChanges() {

    }


    changeLanguage() {
        this._translateService.setDefaultLang(this.selectedLanguage.key);
        let urlSegments = this._router.url.split('/');
        if (this._languages.languages.filter(a => a.key == urlSegments[urlSegments.length - 1]) &&
            this._languages.languages.filter(a => a.key == urlSegments[urlSegments.length - 1]).length > 0) {
            this._router.navigateByUrl(this._router.url.replace(urlSegments[urlSegments.length - 1], this.selectedLanguage.key));
        }
        else
            this._router.navigateByUrl(this._router.url + '/' + this.selectedLanguage.key);
        
        this._translateHelper.rtlLtr(this.selectedLanguage.key);
        this.updateLanguage();
        this.languageKeyChange.emit(this.selectedLanguage.key);

    }
    updateLanguage() {
        this.subscriptions.add(
            this._commonService
                .put(Address.LanguageUpdate, { key: this.selectedLanguage.key }, false)
                .pipe(finalize(() => { }))
                .subscribe(
                    (response: response) => {
                    },
                    (error) => { }
                )
        );
    }

}