import {
  Component,
  OnInit,
  ViewEncapsulation,
  OnDestroy,
  HostListener,
  ChangeDetectorRef,
  AfterViewInit,
  ViewChild,
  OnChanges,
} from '@angular/core';
import { finalize, Subscription } from 'rxjs';
import { MenuItem } from 'primeng/api/public_api';
import { StyleStore } from '@stores/style.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { ActivatedRoute, Router } from '@angular/router';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { CommonService } from '@services/common.service';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { InboxSearch } from '@models/user/InboxSearch';
import { SignalrService } from '@services/signalr.service';
import { RealTimeStore } from '@stores/realTime.store';
import { InboxListModel } from '@models/user/InboxListModel';
import { ColumnKey } from '@enums/columnKey.enum';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { scrollTop } from '@helpers/window.helper';
import { DeviceDetectorService } from 'ngx-device-detector';
import { MenuComponent } from './menu/menu.component';
import { MenuStateStore } from '@stores/loadMenu.store';
import { SearchBoxComponent } from './searchBox/searchBox.component';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';

@Component({
  selector: 'layout',
  templateUrl: 'layout.component.html',
  styleUrls: ['./layout.component.scss'],
  encapsulation: ViewEncapsulation.None,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class LayoutComponent
  implements OnInit, OnDestroy, AfterViewInit, OnChanges {
  constructor(
    private _commonService: CommonService,
    private _styleStore: StyleStore,
    private _router: Router,
    public dialogService: DialogService,
    private cdr: ChangeDetectorRef,
    private _userStore: UserStore,
    private _menuStateStore: MenuStateStore,
    private signalRService: SignalrService,
    private _realTimeStore: RealTimeStore,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    private _companyInfoStore: CompanyInfoStore
  ) {
    this._menuStateStore.menu.subscribe((res) => {
      this.menuState = res;
    });
  }
  ngOnChanges() { }

  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.commonVariables.isSideFix = true;
    } else {
      this.commonVariables.isSideFix = false;
    }
  }
  isDesktop: boolean;
  query: BaseParams = new BaseParams();
  subscriptions = new Subscription();
  menuItems: MenuItem[];
  showSide = false;
  data: UserProfile;
  inboxSearch: InboxSearch = new InboxSearch();
  supportAndTickets: [] = [];
  inboxList: InboxListModel[] = [];
  openMenuProfile: boolean = false;
  totalRecords: number = 0;
  isScrollUp: boolean;
  layoutWidth: string = 'w-full';
  selectedLanguage: string = 'fa';
  menuState: boolean;
  isLoadingGetFull: boolean;
  totalRecordsTickets: any;
  companyId: string;
  companyInfo = new CompanyInfoGet();
  @ViewChild('menu') menu: MenuComponent;
  themMode: boolean = true;
  isDashboard: boolean = false;
  commonVariables: ServicesCommonVariables = new ServicesCommonVariables();
  onActivate(event) {
    scrollTop();
  }

  changeLanguagePanel(e: string = null) { }

  ngAfterViewInit(): void {
    this.changeLanguagePanel();
  }
  ngOnInit() {
    if (
      !stringIsEmptyOrNull(
        this._activatedRoute.snapshot['_routerState'].url.split('/')[
        this._activatedRoute.snapshot['_routerState'].url.split('/').length -
        1
        ]
      )
    ) {
      this.companyId =
        this._activatedRoute.snapshot['_routerState'].url.split('/')[
        this._activatedRoute.snapshot['_routerState'].url.split('/').length -
        1
        ];
    }

    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._styleStore.layoutWith.subscribe((res) => {
      this.layoutWidth = String(res['width']);
      this.isDashboard = res['isDashFooter'];
    });

    this.signalRService.connect();
    this._realTimeStore.realTimeData.subscribe((res) => {

      var msgArray = [];
      if (res != null && res['message'] != null) {
        msgArray = res['message'].split('::');

      }
      if (msgArray[0] == 'InboxGet' && this.data.userId == msgArray[1]) {
        this.userGetInbox();
      }
    });

    this.getFullUser();
    this.cdr.detectChanges();
  }

  getFullUser() {
    this.isLoadingGetFull = true;
    this.cdr.detectChanges();
    this._menuStateStore.menu.next(this.isLoadingGetFull);
    this._menuStateStore.menuBehavior.next(this.isLoadingGetFull);
    this.subscriptions.add(
      this._commonService
        .put(Address.CompanyGetFull, { companyId: this.companyId }, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetFull = false;
            this._menuStateStore.menu.next(this.isLoadingGetFull);
            this._menuStateStore.menuBehavior.next(this.isLoadingGetFull);
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.user) {
              this.data = response.data.user.data;
              this._userStore.user.next(this.data);
              this._userStore.userBehavior.next(this.data);
            }

            if (response.data.menu) {
              this.menuItems = response.data.menu.data;
            }

            if (response.data.company) {
              this.companyInfo = response.data.company.data;
              this._companyInfoStore.company.next(this.companyInfo);
              this._companyInfoStore.companyBehavior.next(this.companyInfo);
              this.cdr.detectChanges();
            }

            if (response.data.inbox) {
              this.inboxSearch.isNew = true;
              this.query.pageSize = 5;
              Object.assign(this.query, this.inboxSearch);
              this.inboxList = response.data.inbox.data;
              this.totalRecords = response.data.inbox.actualSize;
            }

            if (
              response.data.counts &&
              response.data.counts.data &&
              response.data.counts.data.ticketCount
            ) {
              this.query.pageSize = 5;
              this.totalRecordsTickets = response.data.counts.data.ticketCount;
            }
          },
          (error) => { }
        )
    );
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  changeStyle() {
    this.showSide = !this.showSide;
    this._styleStore.contentWidth.next({
      width: '70%',
    });
  }

  getStatus(e) {
    this.openMenuProfile = e;
  }

  userGetInbox() {
    setTimeout(() => {
      this.inboxSearch.isNew = true;
      this.query.pageSize = 5;
      Object.assign(this.query, this.inboxSearch);
      this.subscriptions.add(
        this._commonService
          .put(Address.InboxGet, this.query, false)
          .pipe(finalize(() => { }))
          .subscribe(
            (response: response) => {
              this.inboxList = response.data;
              this.totalRecords = response[ColumnKey.TotalRecordKey]
                ? response[ColumnKey.TotalRecordKey]
                : 0;
            },
            (error) => { }
          )
      );
    }, 100);
  }

  hide() {
    this.showSide = false;
  }
  goToHome() {
    this._router.navigateByUrl('/dashboard/home');
  }

  openNotif(id: string) {
    this._router.navigateByUrl('/dashboard/inbox/' + id + '/' + this.companyId);
  }

  searchModal() {
    const ref = this.dialogService.open(SearchBoxComponent, {
      header: 'جستجو در فراکنش',
      styleClass: 'search-modal',
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {
      if (model) {
        this.cdr.detectChanges();
      }
    });
  }
}
