import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { LayoutComponent } from './layout.component';
import { AcceptCashExchangeWalletComponent } from '../user/wallet/cash-exchange/accept-cash-exchange/accept.component';
import { UserApplicationsComponent } from '../user/user-applications/userApplications.component';
const routes: Routes = [
  {
    path: '',
    component: LayoutComponent,
    children: [
      { path: '', pathMatch: 'full', redirectTo: 'home' },

      {
        path: 'home/:company',
        data: { title: 'داشبورد' },
        loadChildren: () =>
          import('../dashboard/dashboard.module').then(
            (m) => m.DashboardModule
          ),
      },

      {
        path: 'errors/:company',
        loadChildren: () =>
          import('../../errors/errors.module').then((m) => m.ErrorsModule),
      },

      {
        path: 'financial-management',
        data: { title: 'امور مالی و کد تخفیف' },
        loadChildren: () =>
          import('../financial/financial.module').then(
            (m) => m.FinancialModule
          ),
      },
      
      {
        path: 'user/:active/:company',
        data: { title: 'اطلاعات من' },
        loadChildren: () =>
          import('../user/user.module').then((m) => m.UserModule),
      },

      {
        path: 'services',
        data: { title: 'خدمات' },
        loadChildren: () =>
          import('../services/services.module').then((m) => m.ServicesModule),
      },
      
      {
        path: 'Cat',
        data: {
          title: 'صفحه دسته بندی',
          breadcrumb: [{ title: 'صفحه دسته بندی', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('../services/servicesCategory/servicesCategory.module').then(
            (m) => m.ServicesCategoryModule
          ),
      },

      {
        path: 'checkouts',
        data: { title: 'سفارش های من' },
        loadChildren: () =>
          import('../checkouts/checkouts.module').then(
            (m) => m.CheckoutsModule
          ),
      },
      {
        path: 'orders',
        data: { title: 'سفارش های من' },
        loadChildren: () =>
          import('../orders/orders.module').then((m) => m.OrdersModule),
      },

      {
        path: 'tickets/:company',
        data: { title: 'تیکت ها' },
        loadChildren: () =>
          import('../support/tickets/tickets.module').then(
            (m) => m.TicketsModule
          ),
      },

      {
        path: 'inbox/:inboxId/:company',
        data: { title: 'صندوق پیغام' },
        loadChildren: () =>
          import('../support/inbox/inbox.module').then((m) => m.InboxModule),
      },

      {
        path: 'accept-cash-exchange-wallet/:company',
        component: AcceptCashExchangeWalletComponent,
      },
      {
        path: 'user-requests/:company',
        component: UserApplicationsComponent,
        data: { breadcrumb: 'درخواست نقد کردن' },
      },

      { path: '**', redirectTo: 'companies' },
    ],
  },
];
@NgModule({
  imports: [[RouterModule.forChild(routes)]],
  exports: [RouterModule],
})
export class LayoutRoutingModule {}
