import { Component, Input, OnDestroy, OnInit } from '@angular/core';

import { MessageStatic } from '@enums/messageStatic.enum';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { Subscription } from 'rxjs';

@Component({
  selector: 'lightNodeChargeDetail',
  templateUrl: 'lightNodeChargeDetail.component.html',
})
export class LightNodeChargeDetailComponent implements OnInit, OnDestroy {
  constructor(
    public ref: DynamicDialogRef,
    public config: DynamicDialogConfig
  ) {}
  subscriptions = new Subscription();
  @Input() uploadedFiles: IAdditionalFields[];
  @Input() item;
  timeout = null;
  isLoadingGet: boolean = false;
  message: string = MessageStatic.NotFound;
  ngOnInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  downloadFile(fileUrl) {
    window.open(fileUrl, '_blank');
  }
}
