import { Component, Input, OnDestroy, OnInit } from '@angular/core';
import { MessageStatic } from '@enums/messageStatic.enum';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';

import { Subscription } from 'rxjs';

@Component({
  selector: 'PaypalRechargeDetail',
  templateUrl: 'PaypalRechargeDetail.component.html',
})
export class PaypalAccountRechargeDetailComponent implements OnInit, OnDestroy {
  constructor() {}
  subscriptions = new Subscription();
  @Input() item;
  @Input() uploadedFiles: IAdditionalFields[];
  timeout = null;
  isLoadingGet: boolean = false;
  message: string = MessageStatic.NotFound;
  ngOnInit() {}
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  downloadFile(fileUrl) {
    window.open(fileUrl, '_blank');
  }
}
