import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnChanges,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { finalize } from 'rxjs/operators';
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { MessageStatic } from '@enums/messageStatic.enum';
import { Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { cloneDeep } from 'lodash-es';
import { isGuid, stringIsEmptyOrNull } from '@helpers/validator.helper';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { PagingHelper } from '@helpers/paging.helper';
import { FileUploadService } from '@services/fileUpload.service';

@Component({
  selector: 'reciept',
  templateUrl: 'reciept.component.html',
})
export class RecieptComponent implements OnInit, OnDestroy, OnChanges {
  constructor(
    private _commonService: CommonService,
    public ref: DynamicDialogRef,
    public config: DynamicDialogConfig,
    private cdr: ChangeDetectorRef,
    public _pagingHelper: PagingHelper,
    private _fileUploadService: FileUploadService
  ) {}

  ngOnChanges() {}
  subscriptions = new Subscription();
  message: string = MessageStatic.NotFoundReciept;
  @Input() orderId: string;
  @Input() documentType: number;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  isShowOrderDetails: boolean = false;
  fileList: any[] = [];
  reciept: any;
  query: BaseParams;
  totalRecords: number = 0;
  rowsPerPage = this._pagingHelper.rowsPersPage();

  ngOnInit() {
    this.orderId = this.config.data.id;
    this.documentType = this.config.data.documentType;
    this.getFileId();
  }

  close() {
    this.ref.close(this.isShowOrderDetails);
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getFileIdbyChipSelect(type: any) {
    this.documentType = type;
    this.getFileId();
  }

  download(url) {
    window.open(url, '_blank');
  }

  getFileId() {
    this.query = new BaseParams();
    this.isLoadingGetFile = true;
    this.query = this._pagingHelper.requestParamsSet(event, this.query);
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderGetDocument, {
          orderId: this.config.data.id,
          documentType: this.documentType,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetFile = false;
          })
        )
        .subscribe((res: response) => {
          if (res && res.data) {
            this.fileList = cloneDeep(res.data);
            this._fileUploadService.fileUrlGeneratorPutOrderDocument(this.fileList, 'imageId');
          }
        })
    );
  }
}
