import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ConfirmationService, Message } from 'primeng/api';
import { DialogService } from 'primeng/dynamicdialog';
import { PagingHelper } from '@helpers/paging.helper';
import { MessageStatic } from '@enums/messageStatic.enum';
import { convertDateToGeorgian } from '@helpers/dateTime.helper';
import { OrderListModel } from '@models/orders/OrderListModel';
import { cloneDeep } from 'lodash-es';
import { ColumnKey } from '@enums/columnKey.enum';
import { OrderDetailsComponent } from './components/orderDetails/orderDetails.component';
import { Icon } from '@enums/iconKey.enum';
import { StaticModel } from '@models/dbo/StaticModel';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { DeviceDetectorService } from 'ngx-device-detector';
import { ValueTypeStore } from '@stores/getValueType.store';
import { RecieptComponent } from './components/reciept/reciept.component';
@Component({
  selector: 'app-order-list',
  templateUrl: './orderList.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class OrderListComponent implements OnInit, OnDestroy, AfterViewInit {
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private confirmationService: ConfirmationService,
    public dialogService: DialogService,
    public _pagingHelper: PagingHelper,
    public _deviceDetectorService: DeviceDetectorService,
    public _valueTypeStore: ValueTypeStore,
    private _activatedRoute: ActivatedRoute
  ) {}

  overlayVisible: boolean = false;
  overlayDocuments: boolean = false;
  isLoadingGetDocument: boolean = false;
  isLoadingGetFish: boolean;
  subscriptions = new Subscription();
  messages: Message[] = [];
  data: OrderListModel[] = [];
  isTablet: boolean;
  ticket: any;
  filter: any = {};
  order: any = {};
  isLoading: boolean = false;
  query: BaseParams;
  totalRecords: number = 0;
  search: OrderSearchModel = new OrderSearchModel();
  first: number = 0;
  last: number = 0;
  message: string = MessageStatic.NotFoundOrder;
  timeout = null;

  rowsPerPage = this._pagingHelper.rowsPersPage();
  statusList: StaticModel[] = [
    { staticId: 181, title: 'پیش فاکتور' },

    { staticId: 183, title: 'در حال بررسی سند واریزی' },

    { staticId: 186, title: 'انجام شده' },

    { staticId: 188, title: 'در انتظار ارسال فیش پرداختی' },

    { staticId: 189, title: 'تایید نشده' },

    { staticId: 190, title: 'در انتظار عودت وجه' },

    { staticId: 191, title: 'در حال بررسی' },

    { staticId: 192, title: 'در انتظار پرداخت وجه باقی مانده' },

    { staticId: 193, title: 'در انتظار اقدام کارشناسان' },

    { staticId: 194, title: 'در انتظار تسویه حساب' },
    { staticId: 195, title: 'تسویه شده' },
  ];
  staticValueType = [];
  isLoadingStatic: boolean = false;
  fileUrl: string;
  isLoadingReciept: boolean;
  fishList: any[] = [];
  fishUrls: any[] = [];
  chipQuery: any;
  overlayChipResult: boolean = false;
  ngOnInit(): void {
    this.isTablet = this._deviceDetectorService.isTablet();
    this.search.status = -1;
    this.query = new BaseParams();
    Object.assign(this.query, this.search);
  }
  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  toggle(item: any) {
    item.overlayVisible = !item.overlayVisible;
  }
  
  open(item: any = null) {
    this._valueTypeStore.valueType.next(item.valueType);

    const ref = this.dialogService.open(OrderDetailsComponent, {
      data: {
        id: item ? item.orderId : null,
        orderType: item ? item.orderType : null,
        valueType: item ? item.valueType : null,
      },
      header: ' سفارش شماره' + ' ' + item.orderNumber + '# ',
      height: '100%',
      styleClass: 'modal-order-details',
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }

  recieptModal(item: any, model: boolean = null) {
    const ref = this.dialogService.open(RecieptComponent, {
      data: {
        id: item ? item.orderId : null,
        documentType: null,
      },
      header:
        ' رسیدهای ارسالی و دریافتی سفارش شماره' +
        ' ' +
        item.orderNumber +
        '# ' +
        '- ' +
        item.orderTypeName,
      height: '98%',
      styleClass: 'modal-reciept',
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {
      if (model == true) {
        this.getData();
      }
    });
  }

  getDatabyChipSelect(statusId: any) {
    this.search.status = statusId;
    this.getData();
  }

  getData(event: any = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();
    this.search.fromDate = convertDateToGeorgian(this.search.fromDateF);
    this.search.toDate = convertDateToGeorgian(this.search.toDateF);
    if (this.search.status) this.search.status = Number(this.search.status);
    Object.assign(this.query, this.search);
    this.query = this._pagingHelper.requestParamsSet(event, this.query);
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderGetAll, this.query)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            this.staticValueType = res.data.valueType;

            this.data = cloneDeep(res.data);
            this.totalRecords = res[ColumnKey.TotalRecordKey]
              ? res[ColumnKey.TotalRecordKey]
              : 0;
            this.first = this._pagingHelper.firstRecord(this.query);
            this.last = this._pagingHelper.lastRecord(
              this.query,
              this.totalRecords
            );

            this.cdr.detectChanges();
          }
        })
    );
  }

  getFileId(item: any) {
    this.isLoadingGetFish = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderGetDocument, { orderId: item.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGetFish = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res: response) => {
          if (res && res.data) {
            item.fishList = cloneDeep(res.data);

            this.iterateOnDocuments(item);
            this.cdr.detectChanges();
          }
        })
    );
  }

  iterateOnDocuments(item: any) {
    for (let object of item.fishList) {
      this.getDocument(object);
    }
  }

  getDocument(object: any) {
    object.fishUrls = [];
    this.isLoadingGetDocument = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + object.imageId)
        .pipe(
          finalize(() => {
            this.isLoadingGetDocument = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res: response) => {
          object.fishUrls.push(res);

          this.cdr.detectChanges();
        })
    );
  }

  transactionsNavigator(item: OrderListModel) {
    this._router.navigateByUrl(
      '/dashboard/orders/transactions/' +
        item.orderId +
        '/' +
        this._activatedRoute.snapshot.params['company']
    );
  }

  pay(item: any) {
    if (item.valueType) {
      switch (item.valueType) {
        case 'GFC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/giftcard/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );

          break;
        case 'IWP':
          this._router.navigateByUrl(
            '/dashboard/checkouts/internationalpayment/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );

          break;
        case 'PRM':
          this._router.navigateByUrl(
            '/dashboard/checkouts/premium-accounts/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'PAC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal-recharge/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'PAB':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'PAS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal-sell/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'SWF':
          this._router.navigateByUrl(
            '/dashboard/checkouts/swift/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
 

        case 'UNT':
          this._router.navigateByUrl(
            '/dashboard/checkouts/university-tuition/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'HOF':
          this._router.navigateByUrl(
            '/dashboard/checkouts/dormitory-fee/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'APG':
          this._router.navigateByUrl(
            '/dashboard/checkouts/fee-multiple/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'RTS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/renewaltradeserver/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'BTS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/buytradeserver/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'VPS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/buyvirtualserver/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'RVS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/renewalvirtualserver/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'PVS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/voucherperfectmoneysell/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'PMS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingperfectmoney/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'PVC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/voucherperfectmoneybuy/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'PMC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/perfectmoneybuying/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'WIC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/wiseaccountcharge/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'WIS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingwise/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'PYC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/payeeraccountrecharge/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
        case 'PYS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingpayeer/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'TRI':
          this._router.navigateByUrl(
            '/dashboard/checkouts/remittancetoIran/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'ORD':
          this._router.navigateByUrl(
            '/dashboard/checkouts/freeorder/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;

        case 'ICE':
          this._router.navigateByUrl(
            '/dashboard/checkouts/incomecash/' +
              item.orderId +
              '/' +
              this._activatedRoute.snapshot.params['company']
          );
          break;
      }
    } else {
      if (item.status == 181 || item.status == 192) {
        switch (item.orderType) {
          case 161:
            this._router.navigateByUrl(
              '/dashboard/checkouts/swift/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;

          case 909:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;

          case 910:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-recharge/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;

          case 171:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-sell/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 162:
            this._router.navigateByUrl(
              '/dashboard/checkouts/fee/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 905:
            this._router.navigateByUrl(
              '/dashboard/checkouts/fee-multiple/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 175:
            this._router.navigateByUrl(
              '/dashboard/checkouts/university-tuition/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 177:
            this._router.navigateByUrl(
              '/dashboard/checkouts/dormitory-fee/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 163:
            this._router.navigateByUrl(
              '/dashboard/checkouts/perfectmoneybuying/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 178:
            this._router.navigateByUrl(
              '/dashboard/checkouts/buyvirtualserver/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 179:
            this._router.navigateByUrl(
              '/dashboard/checkouts/renewalvirtualserver/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 900:
            this._router.navigateByUrl(
              '/dashboard/checkouts/buytradeserver/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 901:
            this._router.navigateByUrl(
              '/dashboard/checkouts/renewaltradeserver/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 164:
            this._router.navigateByUrl(
              '/dashboard/checkouts/voucherperfectmoneybuy/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 166:
            this._router.navigateByUrl(
              '/dashboard/checkouts/voucherperfectmoneysell/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 165:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingperfectmoney/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 167:
            this._router.navigateByUrl(
              '/dashboard/checkouts/remittancetoIran/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 173:
            this._router.navigateByUrl(
              '/dashboard/checkouts/wiseaccountcharge/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 907:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingwise/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;

          case 169:
            this._router.navigateByUrl(
              '/dashboard/checkouts/payeeraccountrecharge/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 906:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingpayeer/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 959:
            this._router.navigateByUrl(
              '/dashboard/checkouts/incomecash/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 960:
            this._router.navigateByUrl(
              '/dashboard/checkouts/incomecash/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
          case 999:
            this._router.navigateByUrl(
              '/dashboard/checkouts/freeorder/' +
                item.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
            break;
        }
      }
    }
    if (item.status == 188) {
      this._router.navigateByUrl(
        '/dashboard/orders/depositDocument/' +
          item.orderType +
          '/' +
          item.orderId +
          '/' +
          this._activatedRoute.snapshot.params['company']
      );
    }
    if (item.orderType == 907) {
      this._router.navigateByUrl(
        '/dashboard/orders/depositSell/' +
          item.orderType +
          '/' +
          item.orderId +
          '/' +
          this._activatedRoute.snapshot.params['company']
      );
    }
  }

  downloadFish(url) {
    window.open(url, '_blank');
  }
  downloadReciept(item: any) {
    this.isLoadingReciept = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + item.fileOrderId)
        .pipe(
          finalize(() => {
            this.isLoadingReciept = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.fileUrl = response;
            window.open(this.fileUrl, '_blank');

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  cancel(item: any) {
    this.confirmationService.confirm({
      message: 'آیا از لغو کردن سفارش مطمئن هستید؟',
      header: 'کنسل کردن سفارش  ' + item.orderNumber + '#',
      icon: Icon.Warning,

      accept: () => {
        item.isLoading = true;
        this.subscriptions.add(
          this._commonService
            .put(Address.OrderCancel, { orderId: item.orderId })
            .pipe(
              finalize(() => {
                item.isLoading = false;
                this.cdr.detectChanges();
              })
            )
            .subscribe(
              (res) => {
                this._alert.success(
                  'سفارش شما با موفقیت لغو گردید ، در صورتی که مبلغی پرداخت کرده اید ظرف 72 ساعت کاری آینده به حساب شما برگشت داده خواهد شد.'
                );
                this.getData();
                this.cdr.detectChanges();
              },
              (error: any) => {},
              () => {}
            )
        );
      },
      reject: () => {},
      key: 'confirmRemove',
    });
  }
}
