import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { OrdersComponent } from './orders.component';
const routes: Routes = [
  {
    path: '',
    component: OrdersComponent,
    children: [
      { path: '', pathMatch: 'full', redirectTo: 'invoices' },
      { path: ':/company', pathMatch: 'full', redirectTo: 'invoices/en' },

      {
        path: 'invoices/:company',
        data: {
          title: 'سفارش های من',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./orderList/orderList.module').then((m) => m.OrderListModule),
      },

       {
        path: 'depositDocument/:type/:id/:company',
        data: {
          title: 'ارسال فیش واریزی',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./depositDocument/depositDocument.module').then(
            (m) => m.DepositDocumentModule
          ),
      },
      
      {
        path: 'depositDocument/:type/:id/:company/:language',
        data: {
          title: 'ارسال فیش واریزی',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./depositDocument/depositDocument.module').then(
            (m) => m.DepositDocumentModule
          ),
      },

      {
        path: 'depositSell/:type/:id/:company',
        data: {
          title: 'ارسال فیش واریزی',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./publicDepositSell/publicDepositSell.module').then(
            (m) => m.PublicDepositSellModule
          ),
      },

      {
        path: 'transactions/:id/:company',
        data: {
          title: 'تاریخچه ی تراکنش ها',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./transactions/transactions.module').then(
            (m) => m.TransactionsModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class OrdersRoutingModule {}
