import { isGuid, stringIsEmptyOrNull } from '@helpers/validator.helper';
import { Static } from '@interfaces/static';
import { Router, ActivatedRoute } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { OrderModel } from '@models/orders/OrderModel';
import { response } from '@interfaces/response';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { AccountNumberModel } from '@models/orders/AccountNumberModel';
import { getPublicDepositOptions } from '@helpers/values.helper';
import { OrderDocumentModel } from 'src/app/core/params/order/OrderDocumentModel';
import { FileUploadService } from '@services/fileUpload.service';
import { BlockStore } from '@stores/blockOrder';

@Component({
  selector: 'app-deposit-sell',
  templateUrl: './publicDepositSell.component.html',
  styleUrls: ['./publicDepositSell.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PublicDepositSellComponent implements OnInit, OnDestroy {
  subscriptions = new Subscription();

  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _activatedroute: ActivatedRoute,
    private _fileUploadService: FileUploadService,
    public _blockStore: BlockStore
  ) {}

  isRedirectig: boolean;
  documentType: number = 1;
  order: OrderModel;
  accountNumber: AccountNumberModel;
  orderDocument: OrderDocumentModel = new OrderDocumentModel();
  isLoadingGetOrder: boolean = false;
  isLoadingGetAccountNumber: boolean = false;
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  isLoadingUpdate: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  url: string = null;
  file: File;
  progress: number = 0;
  payOnline: boolean;
  expireDate: any;
  dateNow: any;
  imageId: string;
  isExpired: boolean;
  stateDepositDocument: Static[] = getPublicDepositOptions();

  ngOnInit(): void {
    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl(
        '/dashboard/orders/invoices/' +
          this._activatedroute.snapshot.params['company']
      );
    this.orderDocument.orderId = this._activatedroute.snapshot.params['id'];
    this.getAccountNUmber();
  }

  storeBlockOrder() {
    this._blockStore.blockOrder.next({
      statusName: this.order.statusName,
      status: this.order.status,
      currentStatusPage: 181,
    });

    this._blockStore.blockOrderBehavior.next({
      statusName: this.order.statusName,
      status: this.order.status,
      currentStatusPage: 181,
    });
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
    this._blockStore.expireOrderBehavior.next({});
    this._blockStore.blockOrderBehavior.next({});
    this._blockStore.blockOrder.next({});
    this._blockStore.expireOrder.next({});

    this.cdr.detectChanges();
  }
  ngOnChanges() {
    if (this.isExpired == false || this.isExpired == true) {
      this._blockStore.expireOrderBehavior.next(this.isExpired);
      this._blockStore.expireOrder.next(this.isExpired);
      this.cdr.detectChanges();
    }
  }

  redirectToPaymentGateway() {
    this.isRedirectig = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.changeStatusPayOrder,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isRedirectig = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data && response.data.redirectUrl) {
              window.location.href = response.data.redirectUrl;
            }

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }
  fileChange(event) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload();
      this.cdr.detectChanges();
    }
  }

  fileUpload() {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadDocument)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              this.progress = Math.round((event.loaded / eventTotal) * 100);
              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                this.orderDocument.imageId = event.body['data'];
                this.loadFiles(event.body['data']);
                this.isLoadingFile = false;
                this.cdr.detectChanges();
              }
              setTimeout(() => {
                this.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  loadFiles(id: string) {
    this.isLoadingGetFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.isLoadingGetFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.url = response;

            this.extensionStore = String(
              this.url.substring(this.url.lastIndexOf('.') + 1, this.url.length)
            ).toLowerCase();
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }
  updateOrderSellingWisel() {
    if (
      this.orderDocument.imageId == null &&
      stringIsEmptyOrNull(this.orderDocument.trackingCode)
    ) {
      this._alert.warning('یا کد رهگیری و یا سند واریزی را ثبت بفرمایید');
      return;
    }
    this.isLoadingUpdate = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SellingWiseUpdate, {
          imageId: this.orderDocument.imageId,
          transferReference: this.orderDocument.trackingCode,
          orderId: this.orderDocument.orderId,
        })
        .pipe(
          finalize(() => {
            this.isLoadingUpdate = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this._alert.success(
              'سند واریزی با موفقیت ارسال شد ، پس از تایید سفارش شما تایید خواهد شد'
            );
            this.canNotUpload = true;
            this._router.navigateByUrl(
              '/dashboard/orders/invoices/' +
                this._activatedroute.snapshot.params['company']
            );
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }
  remove() {
    this.url = null;
  }

  getOrder() {
    this.isLoadingGetOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetbyId,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.order = response.data;

            if (this.order) {
              this.storeBlockOrder();
            }
            this.accountNumber.description =
              this.accountNumber.description.replace(
                '@number',
                this.order.orderNumber
              );
            // if (
            //   this.order.status != 188 &&
            //   this.order.status != 183 &&
            //   this.order.status != 193
            // ) {
            //   this._router.navigateByUrl('/dashboard/orders');
            // }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getAccountNUmber() {
    this.isLoadingGetAccountNumber = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.AccountNumberGet,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetAccountNumber = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.accountNumber = response.data;

            this.getOrder();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  documentTypeChange(e) {
    switch (e.value) {
      case 1:
        this.orderDocument.trackingCode = null;
        break;
      case 2:
        this.orderDocument.imageId = null;
        this.url = null;
        break;
      default:
        break;
    }
    this.cdr.detectChanges();
  }

  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }
}
