import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';

import { Subscription, finalize } from 'rxjs';


import { fadeAnimation } from 'src/app/core/animations/animations';
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { CategoryModel } from '@models/dbo/categoryModel';
import { cloneDeep } from 'lodash-es';
import { scrollTop } from '@helpers/window.helper';
@Component({
  selector: 'app-all-services',
  templateUrl: './allServices.component.html',
  styleUrls: ['./allServices.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})
export class AllServicesComponent
  implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();
  isLoading: boolean = true;
  allData;
  url: string = null;
  dataCategory: CategoryModel[] = [];
  isLoadingGetCategory: boolean = true;
  header: CategoryModel = new CategoryModel
  isLoadingFile: boolean = false


  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
  ) {
  }

  ngOnInit(): void {
    this.getData();
  }
  ngAfterViewInit() {

  }

  loadFilesStaticImage(item: CategoryModel) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + item.imageId)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            item.fileUrl = response;
            this.cdr.detectChanges();
          },
          (err: any) => { },
          () => { }
        )
    );
  }

  onActivate(event) {
    scrollTop();
  }

  getData() {
    this.isLoadingGetCategory = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.GetAllMenu, { forSidebar: false, key: 'services' },)
        .pipe(
          finalize(() => {
            this.isLoadingGetCategory = false;
            this.cdr.detectChanges();

          })
        )
        .subscribe(
          (response: response) => {
            if (response.data != null && response.data.length > 0) {
              let data;
              data = cloneDeep(response.data)
              for (let item of data) {
                if (!item.parentId) {
                  this.header = item
                }
              }
              this.dataCategory = data.filter(
                (q) => q.parentId != null
              )

              for (let item of this.dataCategory) {
                if (item.imageId) {
                  this.loadFilesStaticImage(item)
                }
              }


            }
          },
          (error) => { }
        )
    );
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}