import { HttpEvent, HttpEventType } from '@angular/common/http';
import {
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnInit,
  Output,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { CommonService } from '@services/common.service';
import { FileUploadService } from '@services/fileUpload.service';
import { Subscription, finalize } from 'rxjs';
import { AdditionalFieldsSaveModel } from 'src/app/core/params/order/AdditionalFieldsSaveModel';

@Component({
  selector: 'app-additional-fields',
  templateUrl: './additional-fields.component.html',
  styleUrls: ['./additional-fields.component.scss'],
})
export class AddionalFieldsComponent implements OnInit, OnChanges {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _fileUploadService: FileUploadService
  ) {}
  ngOnChanges() {
    if (!this.lock) {
      if (this.saveClicked) {
      }
    }
  }
  subscriptions = new Subscription();
  ngOnInit() {
    if (this.additionalFiels && this.additionalFiels.length > 0) {
      for (let i = 0; i < this.additionalFiels.length; i++) {
        this.keyValues = [new AdditionalFieldsSaveModel()];
      }
    }
  }

  @Input() formAttr: any;
  @Input() orderType: any;
  @Output() keyValueChange = new EventEmitter<string>();
  @Input() additionalFiels: IAdditionalFields[] = [];
  @Input() saveClicked: boolean;
  @Output() submitStatus = new EventEmitter<boolean>();
  @Output() changePrice = new EventEmitter<boolean>();
  keyValues: AdditionalFieldsSaveModel[] = [];
  addtionalFieldsJson: string;
  isLoadingGet: boolean;
  lock: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  url: string = null;
  file: File;

  progress: number = 0;

  keyInputSet(itemInput = null) {
    this.keyValues = [];

    for (let item of this.additionalFiels) {
      this.keyValues.push({
        key: item.persianName,
        value: item.value,
        required: item.required,
        keyEnglish : item.englishName
      });
    }

    this.addtionalFieldsJson = JSON.stringify(this.keyValues);

    this.keyValueChange.emit(this.addtionalFieldsJson);
    if(itemInput && itemInput.impact && itemInput.impact>0){
      this.changePrice.emit()
    }
    this.cdr.detectChanges();
  }

  getOrderPrice(item){
    if(item && item.impact && item.impact>0){
      this.changePrice.emit()
    }
  }

  fileChange(event, item) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload(item);
    }
  }

  fileUpload(item) {
    item.isLoadingFile = true;
    this.isLoadingFile = item.isLoadingFile;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadBig)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              item.progress = Math.round((event.loaded / eventTotal) * 100);

              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                item.value = event.body['data'];

                this.loadFiles(event.body['data'], item);
                item.isLoadingFile = false;

                this.cdr.detectChanges();
              }
              setTimeout(() => {
                item.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  loadFiles(id: string, item) {
    this.isLoadingGetFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            item.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            item.url = response;

            this.keyInputSet();

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }
}
