import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { slideInOut } from 'src/app/core/animations/animations';
@Component({
  selector: 'app-legal-order',

  templateUrl: './legal-order.component.html',
  styleUrls: ['./legal-order.component.scss'],
  animations: [slideInOut],
})
export class LegalOrderComponent implements OnInit {
  ngOnInit(): void {}

  animationState = 'out';
  @Input() isLegal: boolean;
  @Input() nationalId: string;
  @Input() registrationNumber: string;
  @Input() nameOfCompany: string;
  @Input() addressOfCompany: string;
  @Input() telOfCompany: string;
  @Input() formAttr: any;
  @Input() isValidForm: boolean = true;
  @Output() isLegalChange = new EventEmitter<boolean>();
  @Output() isValidFormChange = new EventEmitter<boolean>();
  getLegalStuatus() {
    this.animationState = this.animationState === 'out' ? 'in' : 'out';
    if (!this.isLegal) {
      this.nationalId = null;
      this.registrationNumber = null;
      this.nameOfCompany = null;
      this.addressOfCompany = null;
      this.telOfCompany = null;
      this.nationalIdChange.emit(this.nationalId);
      this.registrationNumberChange.emit(this.registrationNumber);
      this.nameOfCompanyChange.emit(this.nameOfCompany);
      this.addressOfCompanyChange.emit(this.addressOfCompany);
      this.telOfCompanyChange.emit(this.telOfCompany);
    }
    this.isLegalChange.emit(this.isLegal);
    this.checkIsValidForm();
  }

  @Output() nationalIdChange = new EventEmitter<string>();
  getNationalId() {
    this.nationalIdChange.emit(this.nationalId);
    this.checkIsValidForm();
  }

  @Output() registrationNumberChange = new EventEmitter<string>();
  getRegistrationNumber() {
    this.registrationNumberChange.emit(this.registrationNumber);
    this.checkIsValidForm();
  }

  @Output() nameOfCompanyChange = new EventEmitter<string>();
  getNameOfCompany() {
    this.nameOfCompanyChange.emit(this.nameOfCompany);
    this.checkIsValidForm();
  }

  @Output() addressOfCompanyChange = new EventEmitter<string>();
  getAddressOfCompany() {
    this.addressOfCompanyChange.emit(this.addressOfCompany);
    this.checkIsValidForm();
  }

  @Output() telOfCompanyChange = new EventEmitter<string>();
  getTelOfCompany() {
    this.telOfCompanyChange.emit(this.telOfCompany);
    this.checkIsValidForm();
  }
  checkIsValidForm() {
    this.isValidForm = true;
    if (
      this.isLegal &&
      (stringIsEmptyOrNull(this.nationalId) ||
        stringIsEmptyOrNull(this.registrationNumber) ||
        stringIsEmptyOrNull(this.nameOfCompany))
    ) {
      this.isValidForm = false;
    }
    this.isValidFormChange.emit(this.isValidForm);
  }
}
