import {
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnInit,
  Output,
 
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { CommonService } from '@services/common.service';
import { Subscription, finalize } from 'rxjs';

@Component({
  selector: 'app-limit',
  templateUrl: './limitations.component.html',
  styleUrls: ['./limitations.component.scss'],
})
export class LimitationsComponent implements OnInit, OnChanges {
  @Input() limitNumber: any;

  subscriptions = new Subscription();
  isLoadingGetLimit: boolean;
  @Input() orderType: any;
  @Output() limitNumberChange = new EventEmitter<number>();
  @Input() isLoadingLimitaion: boolean = false;
  @Output() isLoadingLimitaionChange = new EventEmitter<boolean>();

  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef
  ) {}
  ngOnChanges() {
    if (!this.limitNumber || this.limitNumber == null) {
      this.getLimitNumber();
    }
  }
  ngOnInit() {}

  getLimitNumber() {
    this.isLoadingGetLimit = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderSettingGet,
          {
            orderType: this.orderType,
            isArchive: false
          },
          
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetLimit = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.limitNumber = response.data.maximumNumberPurchase;
            this.limitNumberChange.emit(this.limitNumber);

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }
}
