import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { LegalOrderComponent } from '../../components/legal-order/legal-order.component';
import { DeviceDetectorService } from 'ngx-device-detector';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { ApplicationFeeSaveGroupModel } from 'src/app/core/params/order/ApplicationFeeSaveGroupModel';
import { FileUploadService } from '@services/fileUpload.service';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { PaypalRechargeSaveModel } from 'src/app/core/params/order/PaypalRechargeSaveModel';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { UserProfile } from '@interfaces/user/userProfile';
import { ModalContentMobileComponent } from 'src/app/modules/components/modalContentMobile/modalContentMobile.component';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';

@Component({
  selector: 'app-paypal-sell',
  templateUrl: './paypalSell.component.html',
  styleUrls: ['./paypalSell.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class PaypalSellComponent implements OnInit, OnDestroy, AfterViewInit {
  isShowOrder: boolean = true;
  emailPaypal: string;
  customerDescription: string;
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  url: string = null;
  file: File;
  applicationFeeType: string;
  progress: number = 0;
  orderType: number = 171;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isLoadingGetCurrency: boolean;
  isLoadingGetPrice: boolean;
  inquiryIsOk: boolean = false;
  dataPrice: any;
  model: PaypalRechargeSaveModel = new PaypalRechargeSaveModel();
  isValidLegalForm: boolean = true;
  finalAmount: any;
  timeout = null;
  limitNumber: number;

  companyInfo = new CompanyInfoGet();
  accountType = [
    { title: 'شخصی', value: 521 },
    { title: 'شرکتی', value: 522 },
  ];
  paypalType: any = [
    { title: 'Goods and service', value: '910' },
    { title: 'Family and Friends', value: '940' },
  ];
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _fileUploadService: FileUploadService,
    public _deviceDetectorService: DeviceDetectorService,
    private _router: Router,
    private viewportScroller: ViewportScroller,
    public dialogService: DialogService,
    private _userStore: UserStore,
    private _companyInfoStore: CompanyInfoStore,
    private _activatedRoute: ActivatedRoute
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  dataUser: UserProfile;
  errMsg: any;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  modalGetMobile() {
    const ref = this.dialogService.open(ModalContentMobileComponent, {
      header: 'احراز اطلاعات',
      height: '95%',
      width: '50%',
      styleClass: 'verifyingModal',
      data: { msg: this.errMsg },
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }
  commonVariables: ServicesCommonVariables = new ServicesCommonVariables();

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  ngOnInit(): void {
    this.commonVariables.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.getCurrency();
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.commonVariables.subscriptions.unsubscribe();
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(Number(this.model.amount))) &&
      Number(Number(this.model.amount)) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.finalAmount = Number(this.model.amount);
      this.cdr.detectChanges();
    }
  }

  inquiryOnChange() {
    if (
      !isNaN(Number(Number(this.model.amount))) &&
      Number(Number(this.model.amount)) > 0 &&
      this.selectedCurrency
    ) {
      this.isLoadingGetPrice = true;
      this.getPrice();
      this.cdr.detectChanges();
    }
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.isLoadingGetPrice = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.PaypalSellGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.finalAmount = response.data.finalAmount;

            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getCurrency() {
    this.isLoadingGetCurrency = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetCurrency = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.commonVariables.dataSteps = response.data.steps.data;
            }

            if (response.data.setting && response.data.setting.data) {
              this.commonVariables.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.commonVariables.dataQuestion = response.data.question.data;
              this.commonVariables.totalRecord =
                this.commonVariables.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.commonVariables.dataStatic = response.data.static.data;

              if (this.commonVariables.dataStatic.additionalFields) {
                this.commonVariables.additionalFiels = JSON.parse(
                  this.commonVariables.dataStatic.additionalFields
                );
              }

              if (
                this.commonVariables.dataStatic.imageId &&
                (this.commonVariables.dataStatic.imageId != null ||
                  this.commonVariables.dataStatic.imageId != '')
              ) {
                this.commonVariables.imageId =
                  this.commonVariables.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  submit() {
    if (!this.isValidLegalForm) return;
    this.model.companyId = this._activatedRoute.snapshot.params['company'];
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .post(Address.OrderPaypalSellSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-sell/' +
                response.data.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }

  fileChange(event, item: ApplicationFeeSaveGroupModel = null) {
    if (item == null) {
      let fileList: FileList =
        event.target != undefined && event.target != null
          ? event.target.files
          : event;
      if (fileList.length > 0) {
        this.file = fileList[0];
        this.fileUpload();
      }
    } else {
      let fileList: FileList =
        event.target != undefined && event.target != null
          ? event.target.files
          : event;
      if (fileList.length > 0) {
        this.file = fileList[0];
        this.fileUpload(item);
      }
    }
  }

  fileUpload(item: ApplicationFeeSaveGroupModel = null) {
    this.cdr.detectChanges();
    if (item == null) {
      this.isLoadingFile = true;
      this.commonVariables.subscriptions.add(
        this._fileUploadService
          .fileUpload(this.file.name, this.file, Address.FileUploadBig)
          .subscribe((event: HttpEvent<any>) => {
            switch (event.type) {
              case HttpEventType.Sent:
                break;
              case HttpEventType.ResponseHeader:
                break;
              case HttpEventType.UploadProgress:
                var eventTotal = event.total ? event.total : 0;
                this.progress = Math.round((event.loaded / eventTotal) * 100);
                this.cdr.detectChanges();
                break;
              case HttpEventType.Response:
                if (event.body['data'] != null) {
                  this.model.fileId = event.body['data'];
                  this.loadFiles(event.body['data']);
                  this.isLoadingFile = false;
                  this.cdr.detectChanges();
                }
                setTimeout(() => {
                  this.progress = 0;
                  this.cdr.detectChanges();
                }, 1500);
            }
          })
      );
    } else {
      item.isLoadingFile = true;
      this.commonVariables.subscriptions.add(
        this._fileUploadService
          .fileUpload(this.file.name, this.file, Address.FileUploadBig)
          .subscribe((event: HttpEvent<any>) => {
            switch (event.type) {
              case HttpEventType.Sent:
                break;
              case HttpEventType.ResponseHeader:
                break;
              case HttpEventType.UploadProgress:
                var eventTotal = event.total ? event.total : 0;
                item.progress = Math.round((event.loaded / eventTotal) * 100);
                this.cdr.detectChanges();
                break;
              case HttpEventType.Response:
                if (event.body['data'] != null) {
                  item.fileId = event.body['data'];
                  this.loadFiles(item.fileId, item);
                  item.isLoadingGetFile = false;
                  this.cdr.detectChanges();
                }
                setTimeout(() => {
                  item.progress = 0;
                  this.cdr.detectChanges();
                }, 1500);
            }
          })
      );
    }
  }

  loadFiles(id: string, item: ApplicationFeeSaveGroupModel = null) {
    this.cdr.detectChanges();
    if (item == null) {
      this.isLoadingGetFile = true;
      this.isLoadingFile = true;
      this.commonVariables.subscriptions.add(
        this._commonService
          .getResponseText(Address.GetFileUrl + id)
          .pipe(
            finalize(() => {
              this.isLoadingFile = false;
              this.isLoadingGetFile = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response) => {
              this.url = response;

              this.cdr.detectChanges();
            },
            (err: any) => {},
            () => {}
          )
      );
    } else {
      item.isLoadingGetFile = true;
      item.isLoadingFile = true;
      this.commonVariables.subscriptions.add(
        this._commonService
          .getResponseText(Address.GetFileUrl + id)
          .pipe(
            finalize(() => {
              item.isLoadingFile = false;
              item.isLoadingGetFile = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response) => {
              item.url = response;

              this.cdr.detectChanges();
            },
            (err: any) => {},
            () => {}
          )
      );
    }
  }

  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.commonVariables.isSideFix = true;
    } else {
      this.commonVariables.isSideFix = false;
    }
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
}
