import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { FreezedComponent } from './freezedPage.component';
const routes: Routes = [
  {
    path: '',

    component: FreezedComponent,
    data: {
      breadcrumb: [
        {
          title: 'پرداخت در سایت های خارجی',
          url: '/dashboard/services/internationalpayment',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: ':orderType/:company',

        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderFreezedModule),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class FreezeedRoutingModule {}
