import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { PaymentInternationalSitesPriceModel } from '@models/orders/PaymentInternationalSitesPriceModel';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { PaymentInternationalSitesSaveModel } from 'src/app/core/params/order/PaymentInternationalSitesSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { FileUploadService } from '@services/fileUpload.service';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from '../../../components/legal-order/legal-order.component';
import { IStatic } from '@interfaces/dbo/iStatic';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { ModalContentMobileComponent } from 'src/app/modules/components/modalContentMobile/modalContentMobile.component';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';
@Component({
  selector: 'app-paymentinternationalsites-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderFreezedComponent implements OnInit, OnDestroy, AfterViewInit {
 
  isLoadingGet: boolean = false;
  isValidLegalForm: boolean = true;
  isLoadingGetCountry: boolean = false;
  isLoadingGetCurrency: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isShowOrder: boolean = true;
  data: UserProfile;
   
  timeout = null;
  staticData: IStatic;
   ;
  dataPrice: PaymentInternationalSitesPriceModel;
  model: PaymentInternationalSitesSaveModel =
    new PaymentInternationalSitesSaveModel();
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  isLoadingGetStatic: boolean = true;
  url: string = null;
  file: File;
  progress: number = 0;
  orderType: string;
  fixedEffectiveAmount: string;
  mark: string;
  finalAmount: number;
  currencyId: string;
  keyValues: string;
   commonVariables: ServicesCommonVariables = new ServicesCommonVariables();
   
   
   
   
   
   
   
   ;
  companyInfo = new CompanyInfoGet();
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _fileUploadService: FileUploadService,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    private viewportScroller: ViewportScroller,
    public dialogService: DialogService,
    private _userStore: UserStore,
    private _companyInfoStore: CompanyInfoStore
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[4] != undefined &&
          event.url.split('/')[4] != null &&
          event.url.split('/')[4] != ''
        ) {
          this.handleChangeRoute(event.url.split('/')[4]);
        }
      }
    });
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  dataUser: UserProfile;
  errMsg: any;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  modalGetMobile() {
    const ref = this.dialogService.open(ModalContentMobileComponent, {
      header: 'احراز اطلاعات',
      height: '95%',
      width: '50%',
      styleClass: 'verifyingModal',
      data: { msg: this.errMsg },
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  ngOnInit(): void {
    this.commonVariables.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.handleChangeRoute(this._activatedRoute.snapshot.params['orderType']);

    this.cdr.detectChanges();
  }
  ngAfterViewInit() {}

  ngOnDestroy() {
     this.commonVariables.subscriptions.unsubscribe();
  }
  getKeyValuesAdditional(keyValue) {
    this.keyValues = keyValue;
  }

  fileChange(event) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload();
    }
  }

  fileUpload() {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadBig)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              this.progress = Math.round((event.loaded / eventTotal) * 100);
              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                this.model.fileId = event.body['data'];
                this.loadFiles(event.body['data']);
                this.isLoadingFile = false;
                this.cdr.detectChanges();
              }
              setTimeout(() => {
                this.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  loadFiles(id: string) {
    this.isLoadingGetFile = true;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.isLoadingGetFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.url = response;
            this.extensionStore = String(
              this.url.substring(this.url.lastIndexOf('.') + 1, this.url.length)
            ).toLowerCase();
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }
  remove() {
    this.url = null;
    this.cdr.detectChanges();
  }

  handleChangeRoute(e: string) {
    this.orderType = e;

    this.getStaticById();
  }
  getCurrency() {
    this.isLoadingGetCurrency = true;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: Number(this.orderType),
            sort: 'sortNumber asc',
            pageSize: 50,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetCurrency = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.commonVariables.dataSteps = response.data.steps.data;
            }

            if (response.data.setting && response.data.setting.data) {
              this.commonVariables.dataSetting = response.data.setting.data;
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.commonVariables.dataQuestion = response.data.question.data;
              this.commonVariables.totalRecord = this.commonVariables.dataQuestion.length;
            }

            if (response.data.static.data) {
               this.commonVariables.dataStatic = response.data.static.data;

              if ( this.commonVariables.dataStatic.additionalFields) {
                 this.commonVariables.additionalFiels = JSON.parse(
                   this.commonVariables.dataStatic.additionalFields
                );
              }
              if (
                 this.commonVariables.dataStatic.imageId &&
                ( this.commonVariables.dataStatic.imageId != null ||
                   this.commonVariables.dataStatic.imageId != '')
              ) {
                 this.commonVariables.imageId =  this.commonVariables.dataStatic.imageId;
              }
            }

            this.mark = this.selectedCurrency.mark;
            this.currencyId = this.selectedCurrency.currencyId;

            this.inquiry();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.orderType = Number(this.orderType);
     this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.PaymentInternationalSitesGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.finalAmount = this.dataPrice.finalAmount;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getStaticById() {
    this.isLoadingGetStatic = true;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: Number(this.orderType),
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetStatic = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.staticData = response.data;
            this.fixedEffectiveAmount =
              this.staticData.fixedEffectiveAmount.toString();

            this.getCurrency();

            if (this.staticData.imageId)
              this.loadFilesStaticImage(this.staticData.imageId);
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  loadFilesStaticImage(id: string) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.staticData.fileUrl = response;

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);

    this.model.currencyId = this.currencyId;
    this.model.amount = this.fixedEffectiveAmount;
    this.isLoadingGetPrice = true;
    this.cdr.detectChanges();

    this.timeout = setTimeout(() => {
      this.getPrice();
    }, 900);
  }
  submit() {
    this.model.companyId = this._activatedRoute.snapshot.params['company'];
    if (!this.isValidLegalForm) return;
    this.isLoading = true;
    this.model.additionalValues = this.keyValues;
    this.model.currencyId = this.selectedCurrency.currencyId;

    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .post(Address.PaymentInternationalSitesSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this._router.navigateByUrl(
              '/dashboard/checkouts/internationalpayment/' +
                response.data.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }

   
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.commonVariables.isSideFix = true;
    } else {
      this.commonVariables.isSideFix = false;
    }
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
}
