 
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
 
} from '@angular/core';
 
import {  Subscription } from 'rxjs';
 
import { fadeAnimation } from 'src/app/core/animations/animations';
 

@Component({
  selector: 'app-incomeCashExchange-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class OrderIncomeCashExchangeComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();

  activeIndex: number = 0;

  orderOptions = [
    { value: 167, title: 'ارسال حواله به ایران' },
    { value: 907, title: 'فروش وایز' },
    { value: 171, title: 'نقد کردن پی پال' },
    { value: 166, title: 'فروش ووچر پرفکت مانی (آنی)' },
    { value: 906, title: 'نقد کردن پایر (آنی)' },
    { value: 165, title: 'فروش پرفکت مانی (آنی)' },
  ];
  constructor() {}

  ngOnInit(): void {}
  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
