import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PaymentInternationalSitesComponent } from './paymentInternationalSites.component';
const routes: Routes = [
  {
    path: '',

    component: PaymentInternationalSitesComponent,
    data: {
      breadcrumb: [
        {
          title: 'پرداخت در سایت های خارجی',
          url: '/dashboard/services/internationalpayment/:id/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: ':orderType/:company',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPaymentInternationalSitesModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PaymentInternationalSitesRoutingModule {}
