import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
  OnChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { GiftCardPriceModel } from '@models/orders/GiftCardPriceModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { GiftCardTypeModel } from '@models/orders/GiftCardTypeModel';
import { IGiftCardType } from '@interfaces/orders/iGiftCardType';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { GiftCardSaveModel } from 'src/app/core/params/order/GiftCardSaveModel';
import { IStatic } from '@interfaces/dbo/iStatic';
import {
  DialogService,
  DynamicDialogConfig,
  DynamicDialogRef,
} from 'primeng/dynamicdialog';
import { IGiftcardModal } from '@interfaces/orders/iGiftcardConfig';

import { UserStore } from '@stores/user.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { ModalContentMobileComponent } from 'src/app/modules/components/modalContentMobile/modalContentMobile.component';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';

@Component({
  selector: 'order-giftcard-modal',
  templateUrl: './orderGiftCardModal.component.html',
  styleUrls: ['./orderGiftCardModal.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderGiftcardModalComponent
  implements OnInit, OnDestroy, AfterViewInit, OnChanges
{

  staticData: IStatic;
  isLoadingGetGiftCardType: boolean = false;
  isLoadingGetCurrency: boolean = false;
  isLoadingGetPrice: boolean;
  inquiryIsOk: boolean = true;
  dataGiftCardType: IGiftCardType[] = [];
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  selectedGiftCardType: GiftCardTypeModel;
  isLoadingFile: boolean = false;
  timeout = null;
  dataPrice: GiftCardPriceModel = new GiftCardPriceModel();
  model: GiftCardSaveModel = new GiftCardSaveModel();
  isLoading: boolean = false;
  isShowOrder: boolean = true;
  giftcardModalData: IGiftcardModal = this.config.data;
  companyInfo = new CompanyInfoGet();
  commonVariables: ServicesCommonVariables = new ServicesCommonVariables();
  errMsg: any;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    public config: DynamicDialogConfig,
    public ref: DynamicDialogRef,
    public dialogService: DialogService,
    private _userStore: UserStore,
    private _companyInfoStore: CompanyInfoStore,
    private _activatedRoute: ActivatedRoute
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  dataUser: UserProfile;
  modalGetMobile() {
    const ref = this.dialogService.open(ModalContentMobileComponent, {
      header: 'احراز شماره همراه',
      height: '50%',
      width: '30%',
      styleClass: 'modalGetMobile',
      dismissableMask: true,
      data: { dataUser: this.dataUser },
    });
    ref.onClose.subscribe((model: any) => {});
  }
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;

  ngOnInit() {
    this.commonVariables.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.model.currencyId = this.giftcardModalData.currencyId;
    this.model.orderType = this.giftcardModalData.orderType;
    this.model.giftCardTypeId = this.giftcardModalData.giftCardTypeId;
    this.model.count = 1;

    if (
      !this.giftcardModalData ||
      this.giftcardModalData.price === null ||
      this.giftcardModalData.price === undefined
    ) {
      this.inquiry();
    } else {
      this.dataPrice.finalAmount = this.giftcardModalData.price;
    }

    this.cdr.detectChanges();
  }

  ngAfterViewInit() {}

  ngOnChanges() {}

  ngOnDestroy() {
     this.commonVariables.subscriptions.unsubscribe();
  }
  OnInputCheck() {}

  getStaticById() {
     this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: Number(this.giftcardModalData.orderType),
        })
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            this.staticData = response.data;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  onKey(event: any) {
    this.inquiryIsOk = false;

    if (
      this.giftcardModalData.limitNumber &&
      this.giftcardModalData.limitNumber !== null &&
      event.target.value > this.giftcardModalData.limitNumber
    ) {
      event.target.value = this.giftcardModalData.limitNumber;
    }

    this.inquiry();
  }

  getPrice() {
    this.isLoadingGetPrice = true;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.GiftCardGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;

            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.giftcardModalData.currencyId &&
      this.model.giftCardTypeId &&
      this.model.count &&
      this.model.count !== 0 &&
      !isNaN(this.model.count)
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.inquiryIsOk = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }

    if (this.model.count === 0) {
      this.model.count = 1;
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    }
  }

  submit() {
    this.model.companyId = this._activatedRoute.snapshot.params['company'];
    this.model.amount = this.dataPrice.finalAmount.toString();

    this.isLoading = true;

    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .post(Address.GiftCardSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this.ref.close();
            this._router.navigateByUrl(
              '/dashboard/checkouts/giftcard/' +
                response.data.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }
   
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.commonVariables.isSideFix = true;
    } else {
      this.commonVariables.isSideFix = false;
    }
  }
}
