import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { CountryModel } from '@models/orders/CountryModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from '../../../components/legal-order/legal-order.component';
import { PerfectMoneyBuyingPriceModel } from '@models/orders/perfectMoneyBuyingPriceModel';
import { PerfectMoneyBuyingSaveModel } from 'src/app/core/params/order/PerfectMoneyBuyingSaveModel';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';

import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { UserProfile } from '@interfaces/user/userProfile';
import { ModalContentMobileComponent } from 'src/app/modules/components/modalContentMobile/modalContentMobile.component';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';

@Component({
  selector: 'app-PerfectMoneyBuying-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderPerfectMoneyBuyingComponent
  implements OnInit, OnDestroy, AfterViewInit
{

  isLoadingGetCurrency: boolean = false;
  isLoadingGetPrice: boolean = false;
  isValidLegalForm: boolean = true;
  inquiryIsOk: boolean = false;
  isLoadingGet: boolean = false;
  isLoadingGetCountry: boolean = false;
  dataCountry: CountryModel[] = [];
  dataCurrency: CurrencyModel[] = [];
  selectedCountry: CountryModel;
  selectedCurrency: CurrencyModel;
  isVerify: PerfectMoneyBuyingSaveModel;
   ;
  timeout = null;
  dataPrice: PerfectMoneyBuyingPriceModel;
  model: PerfectMoneyBuyingSaveModel = new PerfectMoneyBuyingSaveModel();
  isLoading: boolean = false;
  isShowOrder: boolean = false;
   
  limitNumber: number;
  isLoadingLimitaion: boolean = false;
   commonVariables: ServicesCommonVariables = new ServicesCommonVariables();
   
   
   
 
   
   
   
   ;
  companyInfo = new CompanyInfoGet();
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _activatedRoute: ActivatedRoute,
    public _deviceDetectorService: DeviceDetectorService,
    private viewportScroller: ViewportScroller,
    private _companyInfoStore: CompanyInfoStore,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  dataUser: UserProfile;
  errMsg: any;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  modalGetMobile() {
    const ref = this.dialogService.open(ModalContentMobileComponent, {
      header: 'احراز اطلاعات',
      height: '95%',
      width: '50%',
      styleClass: 'verifyingModal',
      data: { msg: this.errMsg },
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['company']))
      this._router.navigateByUrl(
        '/dashboard/services/perfectmoneybuying/' +
          this._activatedRoute.snapshot.params['company']
      );
    this.isLoadingGet = true;
    this.commonVariables.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {
    this.getData();
  }

  ngOnDestroy() {
     this.commonVariables.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getData() {
    this.isLoadingGetCurrency = true;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: 163,
            sort: 'sortNumber asc',
            pageSize: 50,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetCurrency = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.commonVariables.dataSteps = response.data.steps.data;
            }
            if (response.data.setting && response.data.setting.data) {
              this.commonVariables.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.commonVariables.dataQuestion = response.data.question.data;
              this.commonVariables.totalRecord = this.commonVariables.dataQuestion.length;
            }

            if (response.data.static.data) {
               this.commonVariables.dataStatic = response.data.static.data;

              if ( this.commonVariables.dataStatic.additionalFields) {
                 this.commonVariables.additionalFiels = JSON.parse(
                   this.commonVariables.dataStatic.additionalFields
                );
              }

              if (
                 this.commonVariables.dataStatic.imageId &&
                ( this.commonVariables.dataStatic.imageId != null ||
                   this.commonVariables.dataStatic.imageId != '')
              ) {
                 this.commonVariables.imageId =  this.commonVariables.dataStatic.imageId;
              }
            }

            this.model.currencyId = this.selectedCurrency.currencyId;
            if (
              !isNaN(Number(  Number(this.model.amount ))) &&
              Number(  Number(this.model.amount )) > 0
            ) {
              this.getPrice();
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.isVerify = this.model.isVerify;

     this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.PerfectMoneyBuyingGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    if (  Number(this.model.amount ) != null &&   Number(this.model.amount ) > this.limitNumber)
        this.model.amount  = this.limitNumber.toString();

    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(  Number(this.model.amount )) &&
        Number(this.model.amount ) > 0
    ) {
      this.isVerify;
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
 
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.inquiryIsOk = false;
      this.cdr.detectChanges();
    }
  }

  submit() {
    if (!this.isValidLegalForm) return;
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
      ;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .post(Address.PerfectMoneyBuyingSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this._router.navigateByUrl(
              '/dashboard/checkouts/perfectmoneybuying/' +
                response.data.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }
   
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.commonVariables.isSideFix = true;
    } else {
      this.commonVariables.isSideFix = false;
    }
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }
  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
}
