import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { PerfectMoneyBuyingComponent } from './perfectMoneyBuying.component';

const routes: Routes = [
  {
    path: '',
    component: PerfectMoneyBuyingComponent,
    data: {
      breadcrumb: [
        {
          title: 'خرید پرفکت مانی',
          url: '/dashboard/services/perfectmoneybuying/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'خرید پرفکت مانی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPerfectMoneyBuyingModule
          ),
      },
      {
        path: ':company',
        data: { title: 'خرید پرفکت مانی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderPerfectMoneyBuyingModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PerfectMoneyBuyingRoutingModule {}
