import { cloneDeep } from 'lodash-es';
import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { UserStore } from '@stores/user.store';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { SellingPerfectMoneyPriceModel } from '@models/orders/sellingPerfectMoneyPriceModel';
import { SellingPerfectMoneySaveModel } from 'src/app/core/params/order/SellingPerfectMoneySaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DetectHelper } from '@helpers/detectHelper';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { ViewportScroller } from '@angular/common';
import { DialogService } from 'primeng/dynamicdialog';
import { ModalContentMobileComponent } from 'src/app/modules/components/modalContentMobile/modalContentMobile.component';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';
@Component({
  selector: 'form-SellingPerfectMoney',
  templateUrl: './formSellingPerfectMoney.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FormSellingPerfectMoneyComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  isLoadingGet: boolean = false;
  isValidLegalForm: boolean = true;
  isLoadingGetCurrency: boolean = false;
  isLoadingGetPrice: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  data: UserProfile;
   commonVariables: ServicesCommonVariables = new ServicesCommonVariables();
   
  timeout = null;
  dataPrice: SellingPerfectMoneyPriceModel;
  model: SellingPerfectMoneySaveModel = new SellingPerfectMoneySaveModel();
  isLoading: boolean = false;
  isShowOrder: boolean = false;
   ;
  limitNumber: number;
   
   
   
   
   
   
   
   ;
  companyInfo = new CompanyInfoGet();
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private _userStore: UserStore,
    private cdr: ChangeDetectorRef,
    private detectHelper: DetectHelper,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private viewportScroller: ViewportScroller,
    public dialogService: DialogService,
    private _companyInfoStore: CompanyInfoStore,
    private _activatedRoute: ActivatedRoute
  ) {    this._companyInfoStore.getCompany().subscribe((res) => {
    if (res != null) {
      this.companyInfo = res;
    }
  });
  this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
    if (res != null) {
      this.companyInfo = res;
    }
  });}

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  dataUser: UserProfile;
  errMsg: any;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  modalGetMobile() {
    const ref = this.dialogService.open(ModalContentMobileComponent, {
      header: 'احراز اطلاعات',
      height: '95%',
      width: '50%',
      styleClass: 'verifyingModal',
      data: { msg: this.errMsg },
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }
  ngOnInit(): void {
    this.isLoadingGet = true;
    this.commonVariables.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.cdr.detectChanges();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
      this.isLoadingGet = false;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.isLoadingGet = false;
        this.cdr.detectChanges();
        this.data = res;
      }
    });
  }

  ngAfterViewInit() {
    this.getCurrency();
  }

  ngOnDestroy() {
     this.commonVariables.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getCurrency() {
    this.isLoadingGetCurrency = true;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            orderType: 165,
            isArchive: false,
            sort: 'sortNumber asc',
            pageSize: 50,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetCurrency = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.commonVariables.dataSteps = response.data.steps.data;
            }

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }
            if (response.data.setting && response.data.setting.data) {
              this.commonVariables.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.commonVariables.dataQuestion = response.data.question.data;
              this.commonVariables.totalRecord = this.commonVariables.dataQuestion.length;
            }

            if (response.data.static.data) {
               this.commonVariables.dataStatic = response.data.static.data;

              if ( this.commonVariables.dataStatic.additionalFields) {
                 this.commonVariables.additionalFiels = JSON.parse(
                   this.commonVariables.dataStatic.additionalFields
                );
              }
              if (
                 this.commonVariables.dataStatic.imageId &&
                ( this.commonVariables.dataStatic.imageId != null ||
                   this.commonVariables.dataStatic.imageId != '')
              ) {
                 this.commonVariables.imageId =  this.commonVariables.dataStatic.imageId;
              }
            }
            this.model.currencyId = this.selectedCurrency.currencyId;
            if (!isNaN(  Number(this.model.amount )) &&   Number(this.model.amount ) > 0) {
              this.getPrice();
              this.cdr.detectChanges();
            }
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;

     this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.SellingPerfectMoneyGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = cloneDeep(response.data);
            this.inquiryIsOk = true;
          },
          (error) => {}
        )
    );
  }

  onFilter() {
    this.detectHelper.fullCompelete(this.cdr);
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(  Number(this.model.amount )) &&
        Number(this.model.amount ) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
        ;
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.inquiryIsOk = false;
      this.cdr.detectChanges();
    }
  }
  submit() {
    this.model.companyId = this._activatedRoute.snapshot.params['company'];
    if (!this.isValidLegalForm) return;
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
      ;
    this.cdr.detectChanges();
     this.commonVariables.subscriptions.add(
      this._commonService
        .post(Address.SellingPerfectMoneySave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingperfectmoney/' +
                response.data.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }

   
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.commonVariables.isSideFix = true;
    } else {
      this.commonVariables.isSideFix = false;
    }
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }
  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
}
