
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from "@angular/core";

import { Subscription } from "rxjs";
import { fadeAnimation } from "src/app/core/animations/animations";
import { scrollTop } from "@helpers/window.helper";
@Component({
  selector: "app-Selling-PerfectMoney",
  templateUrl: "./sellingPerfectMoney.component.html",
  styleUrls: ["./sellingPerfectMoney.component.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})
export class SellingPerfectMoneyComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();

  constructor(

    private cdr: ChangeDetectorRef,

  ) {
    this.cdr;
  }

  ngOnInit(): void {}
  ngAfterViewInit() {}
  onActivate(event) {
    scrollTop();
 }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
