import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { SellingPerfectMoneyComponent } from './sellingPerfectMoney.component';
const routes: Routes = [
  {
    path: '',
    component: SellingPerfectMoneyComponent,
    data: {
      breadcrumb: [
        {
          title: 'فروش پرفکت مانی ',
          url: '/dashboard/services/sellingperfectmoney/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'فروش پرفکت مانی به فراکنش' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderSellingPerfectMoneyModule
          ),
      },
      {
        path: ':company',
        data: { title: 'فروش پرفکت مانی به فراکنش' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderSellingPerfectMoneyModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class SellingPerfectMoneyRoutingModule {}
export class SellingPerfectMoneyModule {}
