import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { VoucherPerfectMoneyComponent } from './voucherPerfectMoney.component';
const routes: Routes = [
  {
    path: '',
    component: VoucherPerfectMoneyComponent,
    data: {
      breadcrumb: [
        {
          title: 'خرید ووچر پرفکت مانی',
          url: '/dashboard/services/voucherperfectmoney/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'خرید ووچر پرفکت مانی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderVoucherPerfectMoneyModule
          ),
      },
      {
        path: ':company',
        data: { title: 'خرید ووچر پرفکت مانی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderVoucherPerfectMoneyModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class VoucherPerfectMoneyRoutingModule {}
