import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-VoucherPerfectMoneySell-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderVoucherPerfectMoneySellComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();
  constructor(private _router:Router,private _activatedRoute:ActivatedRoute) {}

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['company']))
    this._router.navigateByUrl('/dashboard/services/voucherperfectmoneysell/' + this._activatedRoute.snapshot.params['company']);
  }
  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
