import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
  OnChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { CommonService } from '@services/common.service';
import { finalize } from 'rxjs';
import { response } from '@interfaces/response';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { PermiumAccountSaveModel } from 'src/app/core/params/order/PermiumAccountsaveModel';
import { PermiumTypeGet } from '@models/orders/permiumTypeGet';
import { PermiumActivationGet } from '@models/orders/permiumActivationGet';
import { PermiumPeriodGet } from '@models/orders/permiumPeriodGet';
import { PermiumPlanGet } from '@models/orders/permiumPlanGet';
import { PermiumLanguageGet } from '@models/orders/permiumLanguageGet';
import { PermiumCountryGet } from '@models/orders/permiumCountyGet';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { FullResponsePremiumGetModel } from '@models/orders/FullResponsePremiumGetModel';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { UserProfile } from '@interfaces/user/userProfile';
import { ModalContentMobileComponent } from 'src/app/modules/components/modalContentMobile/modalContentMobile.component';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';

@Component({
  selector: 'form-permium',
  templateUrl: './formPermium.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FormPermiumComponent implements OnInit, OnDestroy, OnChanges {
  isLoadingGetCurrency: boolean = false;
  isLoadingGetPrice: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  isValidLegalForm: boolean = true;
  isLoadingFile: boolean = false;
  timeout = null;
  dataPrice: any;
  model: PermiumAccountSaveModel = new PermiumAccountSaveModel();
  isLoading: boolean = false;
  isShowOrder: boolean = true;

  limitNumber: number;
  isLoadingLimitaion: boolean = false;
  keyValues: string;
  orderType: any;
  indexTab: string;
  staticTitle: string;
  commonVariables: ServicesCommonVariables = new ServicesCommonVariables();

  requiredStatus: boolean;
  isRequiredExist: boolean;
  selectedCurrency: CurrencyModel = new CurrencyModel();
  isLoadingGetStatic: boolean = true;
  dataPermiumType: PermiumTypeGet[] = [];
  selectedPermiumType: PermiumTypeGet = new PermiumTypeGet();
  dataPermiumActivation: PermiumActivationGet[] = [];
  selectedPermiumActivation: PermiumActivationGet = new PermiumActivationGet();
  dataPermiumPeriod: PermiumPeriodGet[] = [];
  selectedPermiumPeriod: PermiumPeriodGet = new PermiumPeriodGet();
  fixedEffectiveAmount: number;
  dataPermiumPlan: PermiumPlanGet[] = [];
  selectedPermiumPlan: PermiumPlanGet = new PermiumPlanGet();
  dataPermiumLanguage: PermiumLanguageGet[] = [];
  selectedPermiumLanguage: PermiumLanguageGet = new PermiumLanguageGet();
  dataPermiumCountry: PermiumCountryGet[] = [];
  selectedPermiumCountry: PermiumCountryGet = new PermiumCountryGet();
  mark: string;
  isLoadingGetFullResponse: boolean;
  fullPremiumResponse: FullResponsePremiumGetModel =
    new FullResponsePremiumGetModel();
  companyInfo = new CompanyInfoGet();
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    private viewportScroller: ViewportScroller,
    public dialogService: DialogService,
    private _companyInfoStore: CompanyInfoStore,
    private _userStore: UserStore
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[4] != undefined &&
          event.url.split('/')[4] != null &&
          event.url.split('/')[4] != ''
        ) {
          this.dataPermiumActivation = [];
          this.dataPermiumCountry = [];
          this.dataPermiumLanguage = [];
          this.dataPermiumPeriod = [];
          this.dataPermiumPlan = [];
          this.dataPermiumType = [];
          this.commonVariables.dataSetting = null;
          this.commonVariables.imageId = null;
          this.handleChangeRoute(event.url.split('/')[4]);
        }
      }
    });
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  dataUser: UserProfile;
  errMsg: any;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  modalGetMobile() {
    const ref = this.dialogService.open(ModalContentMobileComponent, {
      header: 'احراز اطلاعات',
      height: '95%',
      width: '50%',
      styleClass: 'verifyingModal',
      data: { msg: this.errMsg },
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }

  ngOnInit() {
    this.commonVariables.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.model.count = 1;
    this.handleChangeRoute(this._activatedRoute.snapshot.params['orderType']);
    this.cdr.detectChanges();
  }

  ngOnChanges() {}

  handleChangeRoute(e: string) {
    this.orderType = e;
    this.getStaticById();
    this.cdr.detectChanges();
  }

  ngOnDestroy() {
    this.commonVariables.subscriptions.unsubscribe();
    this.cdr.detectChanges();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getPremiumAccountFull() {
    this.isLoadingGetFullResponse = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(
          Address.FullPremiumAccount,
          {
            orderType: Number(this.orderType),
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullResponse = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.fullPremiumResponse = response.data;
            if (
              this.fullPremiumResponse.activationType.data &&
              this.fullPremiumResponse.activationType.data.length > 0
            ) {
              this.dataPermiumActivation =
                this.fullPremiumResponse.activationType.data;

              this.model.activationTypePremiumAccountId =
                this.dataPermiumActivation[0].activationTypePremiumAccountId;
            }

            if (
              this.fullPremiumResponse.country.data &&
              this.fullPremiumResponse.country.data.length > 0
            ) {
              this.dataPermiumCountry = this.fullPremiumResponse.country.data;
              this.model.countryPremiumAccountId =
                this.dataPermiumCountry[0].countryPremiumAccountId;
            }

            if (
              this.fullPremiumResponse.language.data &&
              this.fullPremiumResponse.language.data.length > 0
            ) {
              this.dataPermiumLanguage = this.fullPremiumResponse.language.data;
              this.model.languagePremiumAccountId =
                this.dataPermiumLanguage[0].languagePremiumAccountId;
            }

            if (
              this.fullPremiumResponse.type.data &&
              this.fullPremiumResponse.type.data.length > 0
            ) {
              this.dataPermiumType = this.fullPremiumResponse.type.data;
              this.model.typePremiumAccountId =
                this.dataPermiumType[0].typePremiumAccountId;
            }

            if (
              this.fullPremiumResponse.period.data &&
              this.fullPremiumResponse.period.data.length > 0
            ) {
              this.dataPermiumPeriod = this.fullPremiumResponse.period.data;
              this.model.periodPremiumAccountId =
                this.dataPermiumPeriod[0].periodPremiumAccountId;
            }

            if (
              this.fullPremiumResponse.pelan.data &&
              this.fullPremiumResponse.pelan.data.length > 0
            ) {
              this.dataPermiumPlan = this.fullPremiumResponse.pelan.data;
              this.model.pelanPremiumAccountId =
                this.dataPermiumPlan[0].pelanPremiumAccountId;
            }

            if (
              this.fullPremiumResponse.currency.data &&
              this.fullPremiumResponse.currency.data.length > 0
            ) {
              this.dataCurrency = this.fullPremiumResponse.currency.data;

              this.selectedCurrency = this.dataCurrency[0];
            }

            if (
              this.fullPremiumResponse.question.data &&
              this.fullPremiumResponse.question.data.length > 0
            ) {
              this.commonVariables.dataQuestion =
                this.fullPremiumResponse.question.data;
            }

            if (
              this.fullPremiumResponse.steps &&
              this.fullPremiumResponse.steps.data.length > 0
            ) {
              this.commonVariables.dataSteps =
                this.fullPremiumResponse.steps.data;
            }
            if (this.fullPremiumResponse.static.data) {
              this.commonVariables.dataStatic =
                this.fullPremiumResponse.static.data;

              if (this.commonVariables.dataStatic.additionalFields) {
                this.commonVariables.additionalFiels = JSON.parse(
                  this.commonVariables.dataStatic.additionalFields
                );
                for (let item of this.commonVariables.additionalFiels) {
                  this.isRequiredExist = item.required || true;
                }
              }
              if (
                this.commonVariables.dataStatic.imageId &&
                (this.commonVariables.dataStatic.imageId != null ||
                  this.commonVariables.dataStatic.imageId != '')
              ) {
                this.commonVariables.imageId =
                  this.commonVariables.dataStatic.imageId;
              }
              this.staticTitle = this.commonVariables.dataStatic.title;
            }

            if (this.fullPremiumResponse.setting.data) {
              this.commonVariables.dataSetting =
                this.fullPremiumResponse.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }

            this.inquiry();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    if (
      this.dataPermiumActivation ||
      this.dataPermiumCountry ||
      this.dataPermiumLanguage ||
      this.dataPermiumPeriod ||
      this.dataPermiumPlan ||
      this.dataPermiumType
    ) {
      this.isLoadingGetPrice = true;
      this.getPricePermium();
      this.cdr.detectChanges();
    }
  }

  submit() {
    let flag = true;
    if (this.commonVariables.additionalFiels.length > 0) {
      if (this.model.additionalValues != undefined) {
        let dataList = JSON.parse(this.model.additionalValues);
        for (let item of dataList) {
          if (
            item.required &&
            (!item.value || item.value == null || item.value == '')
          ) {
            flag = flag && false;
          } else {
            flag = flag && true;
          }
        }
      } else {
        flag = false;
      }
    }

    if (flag) {
      if (!this.isValidLegalForm) return;
      this.isLoading = true;

      this.model.currencyId = this.selectedCurrency.currencyId;
      this.model.orderType = Number(this.orderType);
      this.model.companyId = this._activatedRoute.snapshot.params['company'];
      this.cdr.detectChanges();
      this.commonVariables.subscriptions.add(
        this._commonService
          .post(Address.OrderPermiumAccountSave, this.model)
          .pipe(
            finalize(() => {
              this.isLoading = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response: response) => {
              this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
              this._router.navigateByUrl(
                '/dashboard/checkouts/premium-accounts/' +
                  response.data.orderId +
                  '/' +
                  this._activatedRoute.snapshot.params['company']
              );
            },
            (error) => {
              this.errMsg = error.status;
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          )
      );
    } else {
      this._alert.error('لطفا از پر کردن تمام بخش‌های ستاره دار مطمئن شوید.');
    }
  }

  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.commonVariables.isSideFix = true;
    } else {
      this.commonVariables.isSideFix = false;
    }
  }

  getPricePermium() {
    if (
      !this.selectedCurrency ||
      stringIsEmptyOrNull(this.selectedCurrency.currencyId)
    )
      return;
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.mark = this.selectedCurrency.mark;
    this.model.orderType = Number(this.orderType);
    this.isLoadingGetPrice = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.OrderPermiumAccountGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }
  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
  getStaticById() {
    this.isLoadingGetStatic = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: Number(this.orderType),
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetStatic = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.fixedEffectiveAmount = response.data.fixedEffectiveAmount;

            this.getPremiumAccountFull();
          },
          (error) => {}
        )
    );
  }
}
