import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';

import { scrollTop } from '@helpers/window.helper';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-permium',
  templateUrl: './permium.component.html',
  styleUrls: ['./permium.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PermiumComponent implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();

  constructor(private cdr: ChangeDetectorRef) {}

  ngOnInit(): void {}
  ngAfterViewInit() {}
  onActivate(event) {
    scrollTop();
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
    this.cdr.detectChanges();
  }
}
