import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { BuyTradeServersComponent } from './buyTradeServers.component';
const routes: Routes = [
  {
    path: '',
    component: BuyTradeServersComponent,
    data: {
      breadcrumb: [
        {
          title: 'خرید سرور مجازی ترید',
          url: '/dashboard/services/buyvirtualserver/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'خرید سرور مجازی ترید' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderBuyTradeServersModule
          ),
      },
      {
        path: ':company',
        data: { title: 'خرید سرور مجازی ترید' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderBuyTradeServersModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class BuyTradeServersRoutingModule {}
