import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { BuyVirtualServersComponent } from './buyVirtualServers.component';
const routes: Routes = [
  {
    path: '',
    component: BuyVirtualServersComponent,
    data: {
      breadcrumb: [
        {
          title: 'خرید سرور مجازی',
          url: '/dashboard/services/buyvirtualserver/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'خرید سرور مجازی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderBuyVirtualServersModule
          ),
      },
      {
        path: ':company',
        data: { title: 'خرید سرور مجازی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderBuyVirtualServersModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class BuyVirtualServersRoutingModule {}
