import { ActivatedRoute, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  ViewChild,
  HostListener,
} from '@angular/core';

import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { RenewalTradeServersPriceModel } from '@models/orders/RenewalTradeServersPriceModel';
import { RenewalTradeServersSaveModel } from 'src/app/core/params/order/RenewalTradeServersSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { DeviceDetectorService } from 'ngx-device-detector';
import { IServerPeriod } from '@interfaces/orders/iServerPeriod';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { ViewportScroller } from '@angular/common';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { ModalContentMobileComponent } from 'src/app/modules/components/modalContentMobile/modalContentMobile.component';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';

@Component({
  selector: 'app-RenewalTradeServers-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class OrderRenewalTradeServersComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  commonVariables: ServicesCommonVariables = new ServicesCommonVariables();

  model: RenewalTradeServersSaveModel = new RenewalTradeServersSaveModel();
  isLoadingGet: boolean = false;
  isLoadingGetCountry: boolean = false;
  isLoadingGetCurrency: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  isLoadingGetServerPeriod: boolean = false;
  dataPeriodServer: IServerPeriod[] = [];
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isShowOrder: boolean = false;
  data: UserProfile;
  timeout = null;
  dataPrice: RenewalTradeServersPriceModel;
  isValidLegalForm: boolean = true;
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  url: string = null;
  file: File;
  limitNumber: number;
  applicationFeeType: string;
  progress: number = 0;
  orderType: number = 901;
  type: number = 2;

  companyInfo = new CompanyInfoGet();
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _companyInfoStore: CompanyInfoStore,
    private _activatedRoute: ActivatedRoute,
    public _deviceDetectorService: DeviceDetectorService,
    private viewportScroller: ViewportScroller,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  dataUser: UserProfile;
  errMsg: any;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  modalGetMobile() {
    const ref = this.dialogService.open(ModalContentMobileComponent, {
      header: 'احراز اطلاعات',
      height: '95%',
      width: '50%',
      styleClass: 'verifyingModal',
      data: { msg: this.errMsg },
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }
  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['company']))
      this._router.navigateByUrl(
        '/dashboard/services/renewaltradevirtualserver/' +
          this._activatedRoute.snapshot.params['company']
      );
    this.commonVariables.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.cdr.detectChanges();
  }
  ngAfterViewInit() {
    this.getCurrency();
  }

  ngOnDestroy() {
    this.commonVariables.subscriptions.unsubscribe();
  }

  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.commonVariables.isSideFix = true;
    } else {
      this.commonVariables.isSideFix = false;
    }
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getCurrency() {
    this.isLoadingGetCurrency = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: this.orderType,
            sort: 'sortNumber asc',
            pageSize: 50,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetCurrency = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.commonVariables.dataSteps = response.data.steps.data;
            }

            if (response.data.setting && response.data.setting.data) {
              this.commonVariables.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.commonVariables.dataQuestion = response.data.question.data;
              this.commonVariables.totalRecord =
                this.commonVariables.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.commonVariables.dataStatic = response.data.static.data;

              if (this.commonVariables.dataStatic.additionalFields) {
                this.commonVariables.additionalFiels = JSON.parse(
                  this.commonVariables.dataStatic.additionalFields
                );
              }

              if (
                this.commonVariables.dataStatic.imageId &&
                (this.commonVariables.dataStatic.imageId != null ||
                  this.commonVariables.dataStatic.imageId != '')
              ) {
                this.commonVariables.imageId =
                  this.commonVariables.dataStatic.imageId;
              }
            }
            if (this.dataCurrency && this.dataCurrency.length == 1) {
              this.selectedCurrency = this.dataCurrency[0];
              this.getServerPeriod();
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getServerPeriod() {
    this.isLoadingGetServerPeriod = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(
          Address.ServerPeriodGetall,
          {
            serverType: this.orderType,
            currencyId: this.selectedCurrency.currencyId,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetServerPeriod = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPeriodServer = response.data;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.type = this.type;

    this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.RenewalVirtualServerGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 901);
    }
  }

  submit() {
    this.model.companyId = this._activatedRoute.snapshot.params['company'];
    if (!this.isValidLegalForm) return;
    this.model.ServerType = '1';
    this.model.type = this.type;

    if (this.selectedCurrency)
      this.model.currencyId = this.selectedCurrency.currencyId;

    this.isLoading = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .post(Address.RenewalVirtualTradeServerSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this._router.navigateByUrl(
              '/dashboard/checkouts/renewaltradeserver/' +
                response.data.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }

  getAmountOfIP() {
    if (this.model.serverIp && this.model.serverIp.length == 15) {
      this.model.currencyId = this.selectedCurrency.currencyId;
      this.commonVariables.subscriptions.add(
        this._commonService
          .put(Address.RenewalVirtualServerGetPrice, this.model, false)
          .subscribe(
            (response: response) => {
              this.model.amount = response.data.amount;
              this.cdr.detectChanges();
            },
            (error) => {}
          )
      );
    }
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
}
