import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { RenewalTradeServersComponent } from './renewalTradeServers.component';
const routes: Routes = [
  {
    path: '',
    component: RenewalTradeServersComponent,
    data: {
      breadcrumb: [
        {
          title: 'تمدید سرور مجازی ترید',
          url: '/dashboard/services/renewaltradevirtualserver/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'تمدید سرور مجازی ترید' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderRenewalTradeServersModule
          ),
      },
      {
        path: ':company',
        data: { title: 'تمدید سرور مجازی ترید' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderRenewalTradeServersModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class RenewalTradeServersRoutingModule {}
