import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { RenewalVirtualServersComponent } from './renewalVirtualServers.component';
const routes: Routes = [
  {
    path: '',
    component: RenewalVirtualServersComponent,
    data: {
      breadcrumb: [
        {
          title: 'تمدید سرور مجازی',
          url: '/dashboard/services/renewalvirtualserver/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'تمدید سرور مجازی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderRenewalVirtualServersModule
          ),
      },
      {
        path: ':company',
        data: { title: 'تمدید سرور مجازی' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderRenewalVirtualServersModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class RenewalVirtualServersRoutingModule {}
