import { Router } from "@angular/router";
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from "@angular/core";
import { AlertHelper } from "@helpers/alert.helper";
import { CommonService } from "@services/common.service";
import { UserStore } from "@stores/user.store";
import { Subscription } from "rxjs";
import { fadeAnimation } from "src/app/core/animations/animations";
import { scrollTop } from "@helpers/window.helper";
@Component({
  selector: "app-selling-Wise",
  templateUrl: "./sellingWise.component.html",
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})
export class SellingWiseComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();

  constructor(
 
    private cdr: ChangeDetectorRef,
   
  ) {
    this.cdr;
  }

  ngOnInit(): void {}
  ngAfterViewInit() {}
  onActivate(event) {
    scrollTop();
 }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
