import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { SellingWiseComponent } from './sellingWise.component';
const routes: Routes = [
  {
    path: '',
    component: SellingWiseComponent,
    data: {
      breadcrumb: [
        {
          title: 'فروش وایز',
          url: '/dashboard/services/sellingwise/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'فروش وایز به فراکنش' },
        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderSellingWiseModule),
      },
      {
        path: ':company',
        data: { title: 'فروش وایز به فراکنش' },
        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderSellingWiseModule),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class SellingWiseRoutingModule {}
export class SellingWiseModule {}
