import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { WiseAccountChargeComponent } from './wiseAccountCharge.component';
const routes: Routes = [
  {
    path: '',
    component: WiseAccountChargeComponent,
    data: {
      breadcrumb: [
        {
          title: 'شارژ حساب وایز',
          url: '/dashboard/services/wiseaccountcharge/:company',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',
        data: { title: 'شارژ حساب وایز' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderWiseAccountChargeModule
          ),
      },
      {
        path: ':company',
        data: { title: 'شارژ حساب وایز' },
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderWiseAccountChargeModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class WiseAccountChargeRoutingModule {}
