import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ServicesComponent } from './services.component';
const routes: Routes = [
  {
    path: '',
    component: ServicesComponent,

    children: [
      {
        path: ':company',

        loadChildren: () =>
          import('./allServices/allServices.module').then(
            (m) => m.AllServicesModule
          ),
      },

      {
        path: 'swift',

        loadChildren: () =>
          import('./swift/swift.module').then((m) => m.SwiftModule),
      },
      {
        path: 'university',

        loadChildren: () =>
          import('./university/university.module').then(
            (m) => m.UniversityModule
          ),
      },
      {
        path: 'swift/:company',
        data: {
          title: 'حواله به خارج از ایران',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./swift/swift.module').then(
            (m) => m.SwiftModule
          ),
      },

      {
        path: 'university',
        data: {
          title: 'خدمات دانشگاهی',
        },
        loadChildren: () =>
          import('./university/university.module').then(
            (m) => m.UniversityModule
          ),
      },

      {
        path: 'paypal-sell/:company',

        data: {
          title: 'فروش پی پال',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./paypal/sell-paypal/paypalSell.module').then(
            (m) => m.PaypalSellModule
          ),
      },
      {
        path: 'paypal-recharge/:company',

        data: {
          title: 'شارژ حساب پی پال',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./paypal/paypal-recharge/paypalRecharge.module').then(
            (m) => m.PaypalRechargeModule
          ),
      },

      {
        path: 'voucherperfectmoney/:company',
        data: {
          title: 'ووچر پرفکت مانی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-perfectMoney/voucherPerfectMoneyBuy/voucherPerfectMoney.module'
          ).then((m) => m.VoucherPerfectMoneyModule),
      },

      {
        path: 'perfectmoneybuying/:company',
        data: {
          title: 'شارژ پرفکت مانی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-perfectMoney/perfectMoneyBuying/perfectMoneyBuying.module'
          ).then((m) => m.PerfectMoneyBuyingModule),
      },

      {
        path: 'sellingperfectmoney/:company',
        data: {
          title: 'فروش پرفکت مانی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-perfectMoney/sellingPerfectMoney/sellingPerfectMoney.module'
          ).then((m) => m.SellingPerfectMoneyModule),
      },

 

      {
        path: 'incomecashexchange/:company',
        data: {
          title: 'نقد کردن درآمد ارزی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-fee/incomeCashExchange/incomeCashExchange.module'
          ).then((m) => m.IncomeCashExchangeModule),
      },

      {
        path: 'payeeraccountrecharge/:company',
        data: {
          title: 'شارژ حساب پایر',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-payeer/payeerAccountRecharge/payeerAccountRecharge.module'
          ).then((m) => m.PayeerAccountRechargeModule),
      },

      {
        path: 'sellingpayeer/:company',
        data: {
          title: 'فروش پایر به فراکنش',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./service-payeer/payeerSelling/payeerSelling.module').then(
            (m) => m.PayeerSellingModule
          ),
      },

      {
        path: 'sellingwise/:company',
        data: {
          title: 'فروش وایز',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./service-wise/sellingWise/sellingWise.module').then(
            (m) => m.SellingWiseModule
          ),
      },
      {
        path: 'wiseaccountcharge/:company',
        data: {
          title: 'شارژ حساب وایز',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-wise/wiseAccountCharge/wiseAccountCharge.module'
          ).then((m) => m.WiseAccountChargeModule),
      },

      {
        path: 'giftcard',

        data: {
          title: 'گیفت کارت',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./service-giftCards/giftCard/giftCard.module').then(
            (m) => m.GiftCardModule
          ),
      },

      {
        path: 'premium-accounts',

        data: {
          title: 'خرید و افتتاح حساب',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./service-permium/permium/permium.module').then(
            (m) => m.PermiumModule
          ),
      },

      {
        path: 'internationalpayment',
        data: {
          title: 'خرید از سایت های بین المللی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-fee/paymentInternationalSites/paymentInternationalSites.module'
          ).then((m) => m.PaymentInternationalSitesModule),
      },

      {
        path: 'internationalpayment-static',
        data: {
          title: 'خرید از سایت های بین المللی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import('./service-fee/freezed-page/freezedPage.module').then(
            (m) => m.FreezeedModule
          ),
      },

      {
        path: 'voucherperfectmoneysell/:company',
        data: {
          title: 'فروش ووچر پرفکت مانی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-perfectMoney/voucherPerfectMoneySell/voucherPerfectMoneySell.module'
          ).then((m) => m.VoucherPerfectMoneySellModule),
      },

      {
        path: 'buyvirtualserver/:company',
        data: {
          title: 'خرید سرور مجازی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-virtualServers/buyVirtualServers/buyVirtualServers.module'
          ).then((m) => m.BuyVirtualServersModule),
      },

      {
        path: 'renewalvirtualserver/:company',
        data: {
          title: 'شارژ سرور مجازی',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-virtualServers/renewalVirtualServers/renewalVirtualServers.module'
          ).then((m) => m.RenewalVirtualServersModule),
      },

      {
        path: 'buytradevirtualserver/:company',
        data: {
          title: 'خرید سرور مجازی ترید',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-virtualServers/buyTradeServers/buyTradeServers.module'
          ).then((m) => m.BuyTradeServersModule),
      },

      {
        path: 'renewaltradevirtualserver/:company',
        data: {
          title: 'تمدید سرور مجازی ترید',
          breadcrumb: [{ title: 'خدمات', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            './service-virtualServers/renewalTradeServers/renewalTradeServers.module'
          ).then((m) => m.RenewalTradeServersModule),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class ServicesRoutingModule {}
