import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ServicesCategoryComponent } from './servicesCategory.component';
const routes: Routes = [
  {
    path: '',
    component: ServicesCategoryComponent,
    data: {
      breadcrumb: [
        {
          title: 'صفحه دسته بندی',
          url: '',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: ':key/:company',
        loadChildren: () =>
          import('./category/category.module').then((m) => m.CategoryModule),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class ServicesCategoryRoutingModule {}
