import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { SwiftComponent } from './swift.component';

const routes: Routes = [
  {
    path: '',
    component: SwiftComponent,
    data: {
      title: 'حواله',
      breadcrumb: [{ title: 'حواله', url: '/dashboard/Cat/swift' }],
    },
    children: [
      {
        path: 'fromIran',

        loadChildren: () =>
          import('./swiftFromIran/fromIran.module').then(
            (m) => m.FromIranModule
          ),
      },
      {
        path: 'fromIran/:language',

        loadChildren: () =>
          import('./swiftFromIran/fromIran.module').then(
            (m) => m.FromIranModule
          ),
      },
      {
        path: 'toIran',

        loadChildren: () =>
          import('./swiftToIran/toIran.module').then((m) => m.ToIranModule),
      },
      {
        path: 'toIran/:language',

        loadChildren: () =>
          import('./swiftToIran/toIran.module').then((m) => m.ToIranModule),
      },
      {
        path: 'university',

        loadChildren: () =>
          import('./swiftUni/swiftUni.module').then((m) => m.SwiftUniModule),
      },
      {
        path: 'university/:language',

        loadChildren: () =>
          import('./swiftUni/swiftUni.module').then((m) => m.SwiftUniModule),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class SwiftRoutingModule {}
