import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { FromIranComponent } from './fromIran.component';
const routes: Routes = [
  {
    path: ':company',
    component: FromIranComponent,
    data: {
      breadcrumb: [
        {
          title: 'حواله به خارج از ایران',
          url: '/dashboard/services/swift/fromIran',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: '',

        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderSwiftTransferModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class FromIranRoutingModule {}
