import { ActivatedRoute, Router } from '@angular/router';
import { VerifyingModel } from '@models/user/VerifyingModel';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { CountryModel } from '@models/orders/CountryModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { SendRemittanceToIranPriceModel } from '@models/orders/SendRemittanceToIranPriceModel';
import { SendRemittanceToIranSaveModel } from 'src/app/core/params/order/SendRemittanceToIranSaveModel';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { isGuid, stringIsEmptyOrNull } from '@helpers/validator.helper';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { FileUploadService } from '@services/fileUpload.service';

@Component({
  selector: 'form-SendRemittanceToIran',
  templateUrl: './formSendRemittanceToIran.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FormSendRemittanceToIranComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  subscriptions = new Subscription();
  isLoadingGetCountry: boolean = false;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  isLoadingGet: boolean = false;
  inquiryIsOk: boolean = false;
  dataCountry: CountryModel[] = [];
  dataCurrency: CurrencyModel[] = [];
  selectedCountry: CountryModel;
  selectedCurrency: CurrencyModel;
  dataVerifying: VerifyingModel[] = [];
  data: UserProfile;
  timeout = null;
  isValidLegalForm: boolean = true;
  dataPrice: SendRemittanceToIranPriceModel;
  model: SendRemittanceToIranSaveModel = new SendRemittanceToIranSaveModel();
  isLoading: boolean = false;
  noExistsBankCard: boolean = true;
  isAcceptBankCard: boolean = true;
  isDesktop: boolean;
  totalQuestionRecord: number = 0;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  limitNumber: number;
  totalRecord: number = 0;
  isSideFix: boolean = false;
  imageId: string;
  dataUser: UserProfile;
  errMsg: any;
  isLodingGetUrl: boolean;
  companyInfo = new CompanyInfoGet();
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedroute: ActivatedRoute,
    public dialogService: DialogService,
    private _userStore: UserStore,
    private _companyInfoStore: CompanyInfoStore,
    private _fileUploadService: FileUploadService
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }

  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedroute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/services/swift/toIran/' +
          this._activatedroute.snapshot.params['language']
      );
    this.isLoadingGet = true;
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.dataUser = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {
    this.getFullOrder();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: 167,
            sort: 'sortNumber asc',
            pageSize: 50,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.getCountry();
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getCountry() {
    this.isLoadingGetCountry = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.CountryGetAll, {useInOrder: true, useInRegister: null}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetCountry = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
           this.dataCountry = response.data.filter((item) => item.isActive);
           this._fileUploadService.fileUrlGeneratorPutCountry(this.dataCountry, 'avatarId');
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.countryId = this.selectedCountry.countryId;
    this.subscriptions.add(
      this._commonService
        .put(Address.SendRemittanceToIranGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCountry &&
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();

      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  submit() {
    this.model.companyId = this.companyInfo.companyId;
    if (!this.isValidLegalForm) return;
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.countryId = this.selectedCountry.countryId;

    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.SendRemittanceToIranSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this._router.navigateByUrl(
              '/dashboard/checkouts/remittancetoIran/' +
                response.data.orderId +
                '/' +
                this.model.companyId
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
}
