import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
} from '@angular/core';
import { scrollTop } from '@helpers/window.helper';
import { Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';
@Component({
  selector: 'toIran',
  templateUrl: './toIran.component.html',
  styleUrls: ['./toIran.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class ToIranComponent implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();

  constructor() {}

  ngOnInit(): void {}
  ngAfterViewInit() {}
  onActivate(event) {
    scrollTop();
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
