import { cloneDeep } from 'lodash-es';
import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ElementRef,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize } from 'rxjs';
import { response } from '@interfaces/response';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { PaymentInternationalSitesSaveModel } from 'src/app/core/params/order/PaymentInternationalSitesSaveModel';
import { PaymentInternationalSitesPriceModel } from '@models/orders/PaymentInternationalSitesPriceModel';
import { IStatic } from '@interfaces/dbo/iStatic';
import { FileUploadService } from '@services/fileUpload.service';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { isUrlValid } from '@helpers/validator.helper';
import { ServicesCommonVariables } from '@models/orders/servicesCommonVariables';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';

@Component({
  selector: 'form-swift-university',
  templateUrl: './formSwiftUni.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FormSwiftUniOrderComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  orderType: string = '983';
  isLoadingGet: boolean = false;
  isValidLegalForm: boolean = true;
  isLoadingGetStatic: boolean = true;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  @ViewChild('priceButton') priceButton!: ElementRef;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isShowOrder: boolean = true;
  data: UserProfile;
  totalQuestionRecord: number = 0;
  timeout = null;
  fixedEffectiveAmount: number;
  isShowFixedEffectiveAmount: boolean;
  staticData: IStatic;
  isDesktop: boolean;
  dataPrice: PaymentInternationalSitesPriceModel;
  model: PaymentInternationalSitesSaveModel =
    new PaymentInternationalSitesSaveModel();
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  companyInfo = new CompanyInfoGet();
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  url: string = null;
  file: File;
  progress: number = 0;
  keyValues: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  displayModal: boolean = false;
  imageId: string;
  isLoadingGetCurrency: boolean = false;
  commonVariables: ServicesCommonVariables = new ServicesCommonVariables();
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _fileUploadService: FileUploadService,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    public _orderTypeStore: OrderTypeStore,
    public dialogService: DialogService,
    private _companyInfoStore: CompanyInfoStore
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[4] != undefined &&
          event.url.split('/')[4] != null &&
          event.url.split('/')[4] != ''
        ) {
          this.imageId = null;
          this.handleChangeRoute(event.url.split('/')[4]);
        }
      }
    });

    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  dataUser: UserProfile;
  errMsg: any;

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;

  ngOnInit(): void {
    this.commonVariables.isDesktop = this._deviceDetectorService.isDesktop();
    this.handleChangeRoute(this._activatedRoute.snapshot.params['orderType']);
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.commonVariables.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  fileChange(event) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload();
    }
  }

  fileUpload() {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadBig)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              this.progress = Math.round((event.loaded / eventTotal) * 100);
              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                this.model.fileId = event.body['data'];
                this.loadFiles(event.body['data']);
                this.isLoadingFile = false;
                this.cdr.detectChanges();
              }
              setTimeout(() => {
                this.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  loadFiles(id: string) {
    this.isLoadingGetFile = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.isLoadingGetFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.url = response;
            this.extensionStore = String(
              this.url.substring(this.url.lastIndexOf('.') + 1, this.url.length)
            ).toLowerCase();
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }
  remove() {
    this.url = null;
    this.cdr.detectChanges();
  }

  handleChangeRoute(e: string) {
    this.getStaticById();
    this.cdr.detectChanges();
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: 983,
            sort: 'sortNumber asc',
            pageSize: 50,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
              this.inquiry();
            }

            if (response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (this.dataCurrency && this.dataCurrency.length == 1) {
              this.selectedCurrency = this.dataCurrency[0];
            }
            if (response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }

              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.orderType = 983;
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.PaymentInternationalSitesGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;
            setTimeout(() => {
              this.scrollToPriceButton();
            }, 0);

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  scrollToPriceButton() {
    if (this.priceButton) {
      this.priceButton.nativeElement.scrollIntoView({
        behavior: 'smooth',
        block: 'center',
      });
    }
  }

  getStaticById() {
    this.isLoadingGetStatic = true;
    this.commonVariables.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: 983,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetStatic = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response) {
              this.staticData = response.data;
              this.getFullOrder();
            }
            if (this.staticData && this.staticData.fixedEffectiveAmount) {
              this.fixedEffectiveAmount = this.staticData.fixedEffectiveAmount;
              this.model.amount = this.fixedEffectiveAmount.toString();
              this.inquiry();
            }
            if (this.staticData && this.staticData.isShowFixedEffectiveAmount) {
              this.isShowFixedEffectiveAmount =
                this.staticData.isShowFixedEffectiveAmount;
            }
            if (this.staticData && this.staticData.imageId) {
              this.loadFilesStaticImage(this.staticData.imageId);
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  loadFilesStaticImage(id: string) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.staticData.fileUrl = response;

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(Number(this.model.amount))) &&
      Number(Number(this.model.amount)) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();

      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    }
  }

  private areAdditionalFieldsValid(): boolean {
    if (!this.additionalFiels.length) return true;
    if (!this.model.additionalValues) return false;

    try {
      const dataList = JSON.parse(this.model.additionalValues);

      return dataList.every((item) => {
        if (!item.required) return true;
        const value = item.value ?? '';
        return value !== '';
      });
    } catch {
      return false;
    }
  }

  submit() {
    this.model.companyId = this.companyInfo.companyId;
    if (!this.areAdditionalFieldsValid()) {
      this._alert.error('لطفا از پر کردن تمام بخش‌های ستاره دار مطمئن شوید.');
      return;
    }
    if (!this.isValidLegalForm) return;
    if (
      !isUrlValid(this.model.pageAddress) &&
      ![
        '972',
        '973',
        '974',
        '975',
        '976',
        '977',
        '978',
        '923',
        '922',
        '921',
        '920',
        '919',
        '924',
        '925',
        '926',
        '927',
        '983',
      ].includes(this.orderType)
    ) {
      this._alert.warning('لطفا آدرس صفحه ورود را بدرستی وارد نمایید');
      this.model.pageAddress = null;
      return;
    }

    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.orderType = 983;
    this.cdr.detectChanges();
    this.commonVariables.subscriptions.add(
      this._commonService
        .post(Address.PaymentInternationalSitesSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._orderTypeStore.orderTypeBehavior.next(
              this.model.orderType.toString()
            );
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this._router.navigateByUrl(
              '/dashboard/checkouts/internationalpayment/' +
                response.data.orderId +
                '/' +
                this._activatedRoute.snapshot.params['company']
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }
  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
